thod_name) - names_to_exclude
                       end
    end

    def method_names
      if Object === receiver
        method_names = receiver.methods + receiver.singleton_methods
        method_names += receiver.private_methods if @private_call
        method_names.uniq!
        # Assume that people trying to use a writer are not interested in a reader
        # and vice versa
        if method_name.match?(/=\Z/)
          method_names.select! { |name| name.match?(/=\Z/) }
        else
          method_names.reject! { |name| name.match?(/=\Z/) }
        end
        method_names
      else
        []
      end
    end

    def names_to_exclude
      Object === receiver ? NAMES_TO_EXCLUDE[receiver.class] : []
    end
  end
end
                                                                                                                                                                                                                                                                                           ruby/did_you_mean/spell_checkers/pattern_key_name_checker.rb                                        0000644                 00000001330 15040313430 0020473 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative "../spell_checker"

module DidYouMean
  class PatternKeyNameChecker
    def initialize(no_matching_pattern_key_error)
      @key = no_matching_pattern_key_error.key
      @keys = no_matching_pattern_key_error.matchee.keys
    end

    def corrections
      @corrections ||= exact_matches.empty? ? SpellChecker.new(dictionary: @keys).correct(@key).map(&:inspect) : exact_matches
    end

    private

    def exact_matches
      @exact_matches ||= @keys.select { |word| @key == word.to_s }.map { |obj| format_object(obj) }
    end

    def format_object(symbol_or_object)
      if symbol_or_object.is_a?(Symbol)
        ":#{symbol_or_object}"
      else
        symbol_or_object.to_s
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                        ruby/did_you_mean/spell_checker.rb                                                                  0000644                 00000002421 15040313430 0013301 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen-string-literal: true

require_relative "levenshtein"
require_relative "jaro_winkler"

module DidYouMean
  class SpellChecker
    def initialize(dictionary:)
      @dictionary = dictionary
    end

    def correct(input)
      normalized_input = normalize(input)
      threshold = normalized_input.length > 3 ? 0.834 : 0.77

      words = @dictionary.select { |word| JaroWinkler.distance(normalize(word), normalized_input) >= threshold }
      words.reject! { |word| input.to_s == word.to_s }
      words.sort_by! { |word| JaroWinkler.distance(word.to_s, normalized_input) }
      words.reverse!

      # Correct mistypes
      threshold   = (normalized_input.length * 0.25).ceil
      corrections = words.select { |c| Levenshtein.distance(normalize(c), normalized_input) <= threshold }

      # Correct misspells
      if corrections.empty?
        corrections = words.select do |word|
          word   = normalize(word)
          length = normalized_input.length < word.length ? normalized_input.length : word.length

          Levenshtein.distance(word, normalized_input) < length
        end.first(1)
      end

      corrections
    end

    private

    def normalize(str_or_symbol) #:nodoc:
      str = str_or_symbol.to_s.downcase
      str.tr!("@", "")
      str
    end
  end
end
                                                                                                                                                                                                                                               ruby/did_you_mean/levenshtein.rb                                                                    0000644                 00000002537 15040313430 0013032 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module DidYouMean
  module Levenshtein # :nodoc:
    # This code is based directly on the Text gem implementation
    # Copyright (c) 2006-2013 Paul Battley, Michael Neumann, Tim Fletcher.
    #
    # Returns a value representing the "cost" of transforming str1 into str2
    def distance(str1, str2)
      n = str1.length
      m = str2.length
      return m if n.zero?
      return n if m.zero?

      d = (0..m).to_a
      x = nil

      # to avoid duplicating an enumerable object, create it outside of the loop
      str2_codepoints = str2.codepoints

      str1.each_codepoint.with_index(1) do |char1, i|
        j = 0
        while j < m
          cost = (char1 == str2_codepoints[j]) ? 0 : 1
          x = min3(
            d[j+1] + 1, # insertion
            i + 1,      # deletion
            d[j] + cost # substitution
          )
          d[j] = i
          i = x

          j += 1
        end
        d[m] = x
      end

      x
    end
    module_function :distance

    private

    # detects the minimum value out of three arguments. This method is
    # faster than `[a, b, c].min` and puts less GC pressure.
    # See https://github.com/ruby/did_you_mean/pull/1 for a performance
    # benchmark.
    def min3(a, b, c)
      if a < b && a < c
        a
      elsif b < c
        b
      else
        c
      end
    end
    module_function :min3
  end
end
                                                                                                                                                                 ruby/did_you_mean/jaro_winkler.rb                                                                   0000644                 00000003410 15040313430 0013163 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module DidYouMean
  module 