# Output the text to +out+, and increment the width to +output_width+
    def output(out, output_width)
      @group.breakables.shift
      if @group.break?
        out << @pp.newline
        out << @pp.genspace.call(@indent)
        @indent
      else
        @pp.group_queue.delete @group if @group.breakables.empty?
        out << @obj
        output_width + @width
      end
    end
  end

  # The Group class is used for making indentation easier.
  #
  # While this class does neither the breaking into newlines nor indentation,
  # it is used in a stack (as well as a queue) within PrettyPrint, to group
  # objects.
  #
  # For information on using groups, see PrettyPrint#group
  #
  # This class is intended for internal use of the PrettyPrint buffers.
  class Group # :nodoc:
    # Create a Group object
    #
    # Arguments:
    # * +depth+ - this group's relation to previous groups
    def initialize(depth)
      @depth = depth
      @breakables = []
      @break = false
    end

    # This group's relation to previous groups
    attr_reader :depth

    # Array to hold the Breakable objects for this Group
    attr_reader :breakables

    # Makes a break for this Group, and returns true
    def break
      @break = true
    end

    # Boolean of whether this Group has made a break
    def break?
      @break
    end

    # Boolean of whether this Group has been queried for being first
    #
    # This is used as a predicate, and ought to be called first.
    def first?
      if defined? @first
        false
      else
        @first = false
        true
      end
    end
  end

  # The GroupQueue class is used for managing the queue of Group to be pretty
  # printed.
  #
  # This queue groups the Group objects, based on their depth.
  #
  # This class is intended for internal use of the PrettyPrint buffers.
  class GroupQueue # :nodoc:
    # Create a GroupQueue object
    #
    # Arguments:
    # * +groups+ - one or more PrettyPrint::Group objects
    def initialize(*groups)
      @queue = []
      groups.each {|g| enq g}
    end

    # Enqueue +group+
    #
    # This does not strictly append the group to the end of the queue,
    # but instead adds it in line, base on the +group.depth+
    def enq(group)
      depth = group.depth
      @queue << [] until depth < @queue.length
      @queue[depth] << group
    end

    # Returns the outer group of the queue
    def deq
      @queue.each {|gs|
        (gs.length-1).downto(0) {|i|
          unless gs[i].breakables.empty?
            group = gs.slice!(i, 1).first
            group.break
            return group
          end
        }
        gs.each {|group| group.break}
        gs.clear
      }
      return nil
    end

    # Remote +group+ from this queue
    def delete(group)
      @queue[group.depth].delete(group)
    end
  end

  # PrettyPrint::SingleLine is used by PrettyPrint.singleline_format
  #
  # It is passed to be similar to a PrettyPrint object itself, by responding to:
  # * #text
  # * #breakable
  # * #nest
  # * #group
  # * #flush
  # * #first?
  #
  # but instead, the output has no line breaks
  #
  class SingleLine
    # Create a PrettyPrint::SingleLine object
    #
    # Arguments:
    # * +output+ - String (or similar) to store rendered text. Needs to respond to '<<'
    # * +maxwidth+ - Argument position expected to be here for compatibility.
    #                This argument is a noop.
    # * +newline+ - Argument position expected to be here for compatibility.
    #               This argument is a noop.
    def initialize(output, maxwidth=nil, newline=nil)
      @output = output
      @first = [true]
    end

    # Add +obj+ to the text to be output.
    #
    # +width+ argument is here for compatibility. It is a noop argument.
    def text(obj, width=nil)
      @output << obj
    end

    # Appends +sep+ to the text to be output. By default +sep+ is ' '
    #
    # +width+ argument is here for compatibility. It is a noop argument.
    def breakable(sep=' ', width=nil)
      @output << sep
    end

    # Takes +indent+ arg, but does nothing with it.
    #
    # Yields to a block.
    def nest(indent) # :nodoc:
      yield
    end

    # Opens a block for grouping objects to be pretty printed.
    #
    # Arguments:
    # * +indent+ - noop argument. Present for compatibility.
    # * +open_obj+ - text appended before the &blok. Default is ''
    # * +close_obj+ - text appended after the &blok. Default is ''
    # * +open_width+ - noop argument. Present for compatibility.
    # * +close_width+ - noop argument. Present for compatibility.
    def group(indent=nil, open_obj='', close_obj='', open_width=nil, close_width=nil)
      @first.push true
      @output << open_obj
      yield
      @output << close_obj
      @first.pop
    end

    # Method present for compatibility, but is a noop
    def flush # :nodoc:
    end

    # This is used as a predicate, and ought to be called first.
    def first?
      result = @first[-1]
      @first[-1] = false
      result
    end
  end
end
                                                                          ruby/logger.rb                                                                                      0000644                 00000054764 15040313431 0007343 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true
# logger.rb - simple logging utility
# Copyright (C) 2000-2003, 2005, 2008, 2011  NAKAMURA, Hiroshi <nahi@ruby-lang.org>.
#
# Documentation:: NAKAMURA, Hiroshi and Gavin Sinclair
# License::
#   You can redistribute it and/or modify it under the same terms 