ruby/did_you_mean/spell_checkers/key_error_checker.rb                                               0000644                 00000001227 15040313430 0017154 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative "../spell_checker"

module DidYouMean
  class KeyErrorChecker
    def initialize(key_error)
      @key = key_error.key
      @keys = key_error.receiver.keys
    end

    def corrections
      @corrections ||= exact_matches.empty? ? SpellChecker.new(dictionary: @keys).correct(@key).map(&:inspect) : exact_matches
    end

    private

    def exact_matches
      @exact_matches ||= @keys.select { |word| @key == word.to_s }.map { |obj| format_object(obj) }
    end

    def format_object(symbol_or_object)
      if symbol_or_object.is_a?(Symbol)
        ":#{symbol_or_object}"
      else
        symbol_or_object.to_s
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                         ruby/did_you_mean/spell_checkers/require_path_checker.rb                                            0000644                 00000002356 15040313430 0017647 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen-string-literal: true

require_relative "../spell_checker"
require_relative "../tree_spell_checker"
require "rbconfig"

module DidYouMean
  class RequirePathChecker
    attr_reader :path

    INITIAL_LOAD_PATH = $LOAD_PATH.dup.freeze
    Ractor.make_shareable(INITIAL_LOAD_PATH) if defined?(Ractor)

    ENV_SPECIFIC_EXT = ".#{RbConfig::CONFIG["DLEXT"]}"
    Ractor.make_shareable(ENV_SPECIFIC_EXT) if defined?(Ractor)

    private_constant :INITIAL_LOAD_PATH, :ENV_SPECIFIC_EXT

    def self.requireables
      @requireables ||= INITIAL_LOAD_PATH
                          .flat_map {|path| Dir.glob("**/???*{.rb,#{ENV_SPECIFIC_EXT}}", base: path) }
                          .map {|path| path.chomp!(".rb") || path.chomp!(ENV_SPECIFIC_EXT) }
    end

    def initialize(exception)
      @path = exception.path
    end

    def corrections
      @corrections ||= begin
                         threshold     = path.size * 2
                         dictionary    = self.class.requireables.reject {|str| str.size >= threshold }
                         spell_checker = path.include?("/") ? TreeSpellChecker : SpellChecker

                         spell_checker.new(dictionary: dictionary).correct(path).uniq
                       end
    end
  end
end
                                                                                                                                                                                                                                                                                  ruby/did_you_mean/spell_checkers/name_error_checkers/variable_name_checker.rb                       0000644                 00000004115 15040313430 0023737 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen-string-literal: true

require_relative "../../spell_checker"

module DidYouMean
  class VariableNameChecker
    attr_reader :name, :method_names, :lvar_names, :ivar_names, :cvar_names

    NAMES_TO_EXCLUDE = { 'foo' => [:fork, :for] }
    NAMES_TO_EXCLUDE.default = []
    Ractor.make_shareable(NAMES_TO_EXCLUDE) if defined?(Ractor)

    # +VariableNameChecker::RB_RESERVED_WORDS+ is the list of all reserved
    # words in Ruby. They could be declared like methods are, and a typo would
    # cause Ruby to raise a +NameError+ because of the way they are declared.
    #
    # The +:VariableNameChecker+ will use this list to suggest a reversed word
    # if a +NameError+ is raised and found closest matches, excluding:
    #
    #   * +do+
    #   * +if+
    #   * +in+
    #   * +or+
    #
    # Also see +MethodNameChecker::RB_RESERVED_WORDS+.
    RB_RESERVED_WORDS = %i(
      BEGIN
      END
      alias
      and
      begin
      break
      case
      class
      def
      defined?
      else
      elsif
      end
      ensure
      false
      for
      module
      next
      nil
      not
      redo
      rescue
      retry
      return
      self
      super
      then
      true
      undef
      unless
      until
      when
      while
      yield
      __LINE__
      __FILE__
      __ENCODING__
    )

    Ractor.make_shareable(RB_RESERVED_WORDS) if defined?(Ractor)

    def initialize(exception)
      @name       = exception.name.to_s.tr("@", "")
      @lvar_names = exception.respond_to?(:local_variables) ? exception.local_variables : []
      receiver    = exception.receiver

      @method_names = receiver.methods + receiver.private_methods
      @ivar_names   = receiver.instance_variables
      @cvar_names   = receiver.class.class_variables
      @cvar_names  += receiver.class_variables if receiver.kind_of?(Module)
    end

    def corrections
      @corrections ||= SpellChecker
                     .new(dictionary: (RB_RESERVED_WORDS + lvar_names + method_names + ivar_names + cvar_names))
                     .correct(name).uniq - NAMES_TO_EXCLUDE[@name]
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                   ruby/did_you_mean/spell_checkers/name_error_checkers/class_name_checker.rb                          0000644                 00000002300 15040313430 0023251 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen-string-literal: true

require_relative "../../spell_checker"

module DidYouMean
  class ClassNameChecker
    attr_reader :class_name

    def initialize(exception)
      @class_name, @receiver, @original_message = exception.name, exception.receiver, exception.original_message
    end

    def corrections
      @corrections ||= SpellChecker.new(dictionary: class_names)
                         .correct(class_name)
                         .map(&:full_name)
                         .reject {|qualified_name| @original_message.include?(qualified_name) }
    end

    def class_names
      scopes.flat_map do |scope|
        scope.constants.map do |c|
          ClassName.new(c, scope == Object ? "" : "#{scope}::")
        end
      end
    end

    def scopes
      @scopes ||= @receiver.to_s.split("::").inject([Object]) do |_scopes, sc