   file gem_path => [package_dir, gem_dir] + @gem_spec.files do
      chdir(gem_dir) do
        when_writing "Creating #{gem_spec.file_name}" do
          Gem::Package.build gem_spec

          verbose trace do
            mv gem_file, ".."
          end
        end
      end
    end
  end
end
                                                                                                                                                                                                                         rubygems/rubygems/tsort.rb                                                                          0000644                 00000000102 15040313421 0011720 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        implementation, every version of the option needs
  # to be expli                                                                                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/update_suggestion.rb                                                              0000644                 00000003553 15040313421 0014313 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Mixin methods for Gem::Command to promote available RubyGems update

module Gem::UpdateSuggestion
  ONE_WEEK = 7 * 24 * 60 * 60

  ##
  # Message to promote available RubyGems update with related gem update command.

  def update_suggestion
    <<-MESSAGE

A new release of RubyGems is available: #{Gem.rubygems_version} → #{Gem.latest_rubygems_version}!
Run `gem update --system #{Gem.latest_rubygems_version}` to update your installation.

    MESSAGE
  end

  ##
  # Determines if current environment is eligible for update suggestion.

  def eligible_for_update?
    # explicit opt-out
    return false if Gem.configuration[:prevent_update_suggestion]
    return false if ENV["RUBYGEMS_PREVENT_UPDATE_SUGGESTION"]

    # focus only on human usage of final RubyGems releases
    return false unless Gem.ui.tty?
    return false if Gem.rubygems_version.prerelease?
    return false if Gem.disable_system_update_message
    return false if Gem::CIDetector.ci?

    # check makes sense only when we can store timestamp of last try
    # otherwise we will not be able to prevent "annoying" update message
    # on each command call
    return unless Gem.configuration.state_file_writable?

    # load time of last check, ensure the difference is enough to repeat the suggestion
    check_time = Time.now.to_i
    last_update_check = Gem.configuration.last_update_check
    return false if (check_time - last_update_check) < ONE_WEEK

    # compare current and latest version, this is the part where
    # latest rubygems spec is fetched from remote
    (Gem.rubygems_version < Gem.latest_rubygems_version).tap do |eligible|
      # store the time of last successful check into state file
      Gem.configuration.last_update_check = check_time

      return eligible
    end
  rescue StandardError # don't block install command on any problem
    false
  end
end
                                                                                                                                                     rubygems/rubygems/install_update_options.rb                                                         0000644                 00000015102 15040313421 0015336 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "../rubygems"
require_relative "security_option"

##
# Mixin methods for install and update options for Gem::Commands

module Gem::InstallUpdateOptions
  include Gem::SecurityOption

  ##
  # Add the install/update options to the option parser.

  def add_install_update_options
    add_option(:"Install/Update", "-i", "--install-dir DIR",
               "Gem repository directory to get installed",
               "gems") do |value, options|
      options[:install_dir] = File.expand_path(value)
    end

    add_option(:"Install/Update", "-n", "--bindir DIR",
               "Directory where executables will be",
               "placed when the gem is installed") do |value, options|
      options[:bin_dir] = File.expand_path(value)
    end

    add_option(:"Install/Update", "--document [TYPES]", Array,
               "Generate documentation for installed gems",
               "List the documentation types you wish to",
               "generate.  For example: rdoc,ri") do |value, options|
      options[:document] = case value
                           when nil   then %w[ri]
                           when false then []
                           else value
      end
    end

    add_option(:"Install/Update", "--build-root DIR",
               "Temporary installation root. Useful for building",
               "packages. Do not use this when installing remote gems.") do |value, options|
      options[:build_root] = File.expand_path(value)
    end

    add_option(:"Install/Update", "--vendor",
               "Install gem into the vendor directory.",
               "Only for use by gem repackagers.") do |_value, options|
      unless Gem.vendor_dir
        raise Gem::OptionParser::InvalidOption.new "your platform is not supported"
      end

      options[:vendor] = true
      options[:install_dir] = Gem.vendor_dir
    end

    add_option(:"Install/Update", "-N", "--no-document",
               "Disable documentation generation") do |_value, options|
      options[:document] = []
    end

    add_option(:"Install/Update", "-E", "--[no-]env-shebang",
               "Rewrite the shebang line on installed",
               "scripts to use /usr/bin/env") do |value, options|
      options[:env_shebang] = value
    end

    add_option(:"Install/Update", "-f", "--[no-]force",
               "Force gem to install, bypassing dependency",
               "checks") do |value, options|
      options[:force] = value
    end

    add_option(:"Install/Update", "-w", "--[no-]wrappers",
               "Use bin wrappers for executables",
               "Not available on dosish platforms") do |value, options|
      options[:wrappers] = value
    end

    add_security_option

    add_option(:"Install/Update", "--ignore-dependencies",
               "Do not install any required dependent gems") do |value, options|
      options[:ignore_dependencies] = value
    end

    add_option(:"Install/Update", "--[no-]format-executable",
               "Make installed executable names match Ruby.",
               "If Ruby is ruby1