

      def reason_phrase
        "OK"
      end

      def body
        "success"
      end
    end

    class NoContentResponse < Response
      private

      def code
        204
      end

      def reason_phrase
        "No Content"
      end
    end

    class BadRequestResponse < Response
      private

      def code
        400
      end

      def reason_phrase
        "Bad Request"
      end

      def body
        "missing code parameter"
      end
    end

    class NotFoundResponse < Response
      private

      def code
        404
      end

      def reason_phrase
        "Not Found"
      end
    end

    class MethodNotAllowedResponse < Response
      private

      def code
        405
      end

      def reason_phrase
        "Method Not Allowed"
      end

      def add_access_control_headers
        super
        @http_response["allow"] = %w[GET OPTIONS]
      end
    end
  end
end
                                                                                                       rubygems/rubygems/commands/unpack_command.rb                                                        0000644                 00000010222 15040313420 0015330 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../version_option"
require_relative "../security_option"
require_relative "../remote_fetcher"
require_relative "../package"

# forward-declare

module Gem::Security # :nodoc:
  class Policy # :nodoc:
  end
end

class Gem::Commands::UnpackCommand < Gem::Command
  include Gem::VersionOption
  include Gem::SecurityOption

  def initialize
    require "fileutils"

    super "unpack", "Unpack an installed gem to the current directory",
          version: Gem::Requirement.default,
          target: Dir.pwd

    add_option("--target=DIR",
               "target directory for unpacking") do |value, options|
      options[:target] = value
    end

    add_option("--spec", "unpack the gem specification") do |_value, options|
      options[:spec] = true
    end

    add_security_option
    add_version_option
  end

  def arguments # :nodoc:
    "GEMNAME       name of gem to unpack"
  end

  def defaults_str # :nodoc:
    "--version '#{Gem::Requirement.default}'"
  end

  def description
    <<-EOF
The unpack command allows you to examine the contents of a gem or modify
them to help diagnose a bug.

You can add the contents of the unpacked gem to the load path using the
RUBYLIB environment variable or -I:

  $ gem unpack my_gem
  Unpacked gem: '.../my_gem-1.0'
  [edit my_gem-1.0/lib/my_gem.rb]
  $ ruby -Imy_gem-1.0/lib -S other_program

You can repackage an unpacked gem using the build command.  See the build
command help for an example.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} GEMNAME"
  end

  #--
  # TODO: allow, e.g., 'gem 