    DESC
  end

  def usage # :nodoc:
    "#{program_name} [args]"
  end

  def execute
    specs = if options[:all]
      Gem::Specification.to_a
    else
      get_all_gem_names.flat_map do |name|
        Gem::Specification.find_by_name name, options[:version]
      end.uniq
    end

    if specs.empty?
      alert_error "No matching gems found"
      terminate_interaction 1
    end

    specs.each do |spec|
      doc = Gem::RDoc.new spec, options[:include_rdoc], options[:include_ri]

      doc.force = options[:overwrite]

      if options[:overwrite]
        FileUtils.rm_rf File.join(spec.doc_dir, "ri")
        FileUtils.rm_rf File.join(spec.doc_dir, "rdoc")
      end

      doc.generate
    end
  end
end
                                                                                                                                                                                                                                                                                                                  rubygems/rubygems/commands/build_command.rb                                                         0000644                 00000005670 15040313420 0015161 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../gemspec_helpers"
require_relative "../package"
require_relative "../version_option"

class Gem::Commands::BuildCommand < Gem::Command
  include Gem::VersionOption
  include Gem::GemspecHelpers

  def initialize
    super "build", "Build a gem from a gemspec"

    add_platform_option

    add_option "--force", "skip validation of the spec" do |_value, options|
      options[:force] = true
    end

    add_option "--strict", "consider warnings as errors when validating the spec" do |_value, options|
      options[:strict] = true
    end

    add_option "-o", "--output FILE", "output gem with the given filename" do |value, options|
      options[:output] = value
    end

    add_option "-C PATH", "Run as if gem build was started in <PATH> instead of the current working directory." do |value, options|
      options[:build_path] = value
    end
    deprecate_option "-C",
                     version: "4.0",
                     extra_msg: "-C is a global flag now. Use `gem -C PATH build GEMSPEC_FILE [options]` instead"
  end

  def arguments # :nodoc:
    "GEMSPEC_FILE  gemspec file name to build a gem for"
  end

  def description # :nodoc:
    <<-EOF
The build command allows you to create a gem from a ruby gemspec.

The best way to build a gem is to use a Rakefile and the Gem::PackageTask
which ships with RubyGems.

The gemspec can either be created by hand or extracted from an existing gem
with gem spec:

  $ gem unpack my_gem-1.0.gem
  Unpacked gem: '.../my_gem-1.0'
  $ gem spec my_gem-1.0.gem --ruby > my_gem-1.0/my_gem-1.0.gemspec
  $ cd my_gem-1.0
  [edit gem contents]
  $ gem build my_gem-1.0.gemspec

Gems can be saved to a specified filename with the output option:

  $ gem build my_gem-1.0.gemspec --output=release.gem

    EOF
  end

  def usage # :nodoc:
    "#{program_name} GEMSPEC_FILE"
  end

  def execute
    if build_path = options[:build_path]
      Dir.chdir(build_path) { build_gem }
      return
    end

    build_gem
  end

  private

  def build_gem
    gemspec = resolve_gem_name

    if gemspec
      build_package(gemspec)
    else
      alert_error error_message
      terminate_interaction(1)
    end
  end

  def build_package(gemspec)
    spec = Gem::Specification.load(gemspec)
    if spec
      Gem::Package.build(
        spec,
        options[:force],
        options[:strict],
        options[:output]
      )
    else
      alert_error "Error loading gemspec. Aborting."
      terminate_interaction 1
    end
  end

  def resolve_gem_name
    return find_gemspec unless gem_nam