ms",        PLATFORMS],
  ].freeze
  # :startdoc:

  def initialize
    super "help", "Provide help on the 'gem' command"

    @command_manager = Gem::CommandManager.instance
  end

  def usage # :nodoc:
    "#{program_name} ARGUMENT"
  end

  def execute
    arg = options[:args][0]

    _, help = SUBCOMMANDS.find do |command,|
      begins? command, arg
    end

    if help
      if Symbol === help
        send help
      else
        say help
      end
      return
    end

    if options[:help]
      show_help

    elsif arg
      show_command_help arg

    else
      say Gem::Command::HELP
    end
  end

  def show_commands # :nodoc:
    out = []
    out << "GEM commands are:"
    out << nil

    margin_width = 4

    desc_width = @command_manager.command_names.map(&:size).max + 4

    summary_width = 80 - margin_width - desc_width
    wrap_indent = " " * (margin_width + desc_width)
    format = "#{" " * margin_width}%-#{desc_width}s%s"

    @command_manager.command_names.each do |cmd_name|
      command = @command_manager[cmd_name]

      next if command&.deprecated?

      summary =
        if command
          command.summary
        else
          "[No command found for #{cmd_name}]"
        end

      summary = wrap(summary, summary_width).split "\n"
      out << format(format, cmd_name, summary.shift)
      until summary.empty? do
        out << "#{wrap_indent}#{summary.shift}"
      end
    end

    out << nil
    out << "For help on a particular command, use 'gem help COMMAND'."
    out << nil
    out << "Commands may be abbreviated, so long as they are unambiguous."
    out << "e.g. 'gem i rake' is short for 'gem install rake'."

    say out.join("\n")
  end

  def show_command_help(command_name) # :nodoc:
    command_name = command_name.downcase

    possibilities = @command_manager.find_command_possibilities command_name

    if possibilities.size == 1
      command = @command_manager[possibilities.first]
      command.invoke("--help")
    elsif possibilities.size > 1
      alert_warning "Ambiguous command #{command_name} (#{possibilities.join(", ")})"
    else
      alert_warning "Unknown command #{command_name}. Try: gem help commands"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                               rubygems/rubygems/commands/dependency_command.rb                                                    0000644                 00000012126 15040313420 0016172 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../local_remote_options"
require_relative "../version_option"

class Gem::Commands::DependencyCommand < Gem::Command
  include Gem::LocalRemoteOptions
  include Gem::VersionOption

  def initialize
    super "dependency",
          "Show the dependencies of an installed gem",
          version: Gem::Requirement.default, domain: :local

    add_version_option
    add_platform_option
    add_prerelease_option

    add_option("-R", "--[no-]reverse-dependencies",
               "Include reverse dependencies in the output") do |value, options|
      options[:reverse_dependencies] = value
    end

    add_option("-p", "--pipe",
               "Pipe Format (name --version ver)") do |value, options|
      options[:pipe_format] = value
    end

    add_local_remote_options
  end

  def arguments # :nodoc:
    "REGEXP        show dependencies for gems whose names start with REGEXP"
  end

  def defaults_str # :nodoc:
    "--local --version '#{Gem::Requirement.default}' --no-reverse-dependencies"
  end

  def description # :nodoc:
    <<-EOF
The dependency commands lists which other gems a given gem depends on.  For
local gems only the reverse dependencies can be shown (which gems depend on
the named gem).

The dependency list can be displayed in a format suitable for piping for
use with other commands.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} REGEXP"
  end

  def fetch_remote_specs(name, requirement, prerelease) # :nodoc:
    fetcher = Gem::SpecFetcher.fetcher

    specs_type = prerelease ? :complete : :released

    ss = if name.nil?
      fetcher.detect(specs_type) { true }
    else
      fetcher.detect(specs_type) do |name_tuple|
        name === name_tuple.name && requirement.satisfied_by?(name_tuple.version)
      end
    end

    ss.map {|tuple, source| source.fetch_spec(tuple) }
  end

  def fetch_specs(name_pattern, requirement, prerelease) # :nodoc:
    specs = []

    if local?
      specs.concat Gem::Specification.stubs.find_all {|spec|
        name_matches = name_pattern ? name_pattern =~ spec.name : true
        version_matches = requirement.satisfied_by?(spec.version)

        name_matches && version_matches
      }.map(&:to_spec)
    end

    specs.concat fetch_remote_specs name_pattern, requirement, prerele