ner_scope(method: method) do |request|
      request.set_form_data "email" => owner
      request.add_field "Authorization", api_key
    end
  end

  def get_owner_scope(method: nil)
    if method == :post || options.any? && options[:add].any?
      :add_owner
    elsif method == :delete || options.any? && options[:remove].any?
      :remove_owner
    end
  end
end
                                                                                                                                                rubygems/rubygems/commands/search_command.rb                                                        0000644                 00000001702 15040313420 0015317 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../query_utils"

class Gem::Commands::SearchCommand < Gem::Command
  include Gem::QueryUtils

  def initialize
    super "search", "Display remote gems whose name matches REGEXP",
         domain: :remote, details: false, versions: true,
         installed: nil, version: Gem::Requirement.default

    add_query_options
  end

  def arguments # :nodoc:
    "REGEXP        regexp to search for in gem name"
  end

  def defaults_str # :nodoc:
    "--remote --no-details"
  end

  def description # :nodoc:
    <<-EOF
The search command displays remote gems whose name matches the given
regexp.

The --details option displays additional details from the gem but will
take a little longer to complete as it must download the information
individually from the index.

To list local gems use the list command.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} [REGEXP]"
  end
end
                                                              rubygems/rubygems/commands/which_command.rb                                                         0000644                 00000004133 15040313420 0015155 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"

class Gem::Commands::WhichCommand < Gem::Command
  def initialize
    super "which", "Find the location of a library file you can require",
          search_gems_first: false, show_all: false

    add_option "-a", "--[no-]all", "show all matching files" do |show_all, options|
      options[:show_all] = show_all
    end

    add_option "-g", "--[no-]gems-fi