le to find gem '#{name}' in #{@path_kind}"

    if Gem.configuration.verbose
      say "\nDirectories searched:"
      @spec_dirs.sort.each {|dir| say dir }
    end

    nil
  end

  def specification_directories # :nodoc:
    options[:specdirs].flat_map do |i|
      [i, File.join(i, "specifications")]
    end
  end
end
                                                                                                                                                                                              rubygems/rubygems/commands/cleanup_command.rb                                                       0000644                 00000010421 15040313420 0015477 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../dependency_list"
require_relative "../uninstaller"

class Gem::Commands::CleanupCommand < Gem::Command
  def initialize
    super "cleanup",
          "Clean up old versions of installed gems",
          force: false, install_dir: Gem.dir,
          check_dev: true

    add_option("-n", "-d", "--dry-run",
               "Do not uninstall gems") do |_value, options|
      options[:dryrun] = true
    end

    add_option(:Deprecated, "--dryrun",
               "Do not uninstall gems") do |_value, options|
      options[:dryrun] = true
    end
    deprecate_option("--dryrun", extra_msg: "Use --dry-run instead")

    add_option("-D", "--[no-]check-development",
               "Check development dependencies while uninstalling",
               "(default: true)") do |value, options|
      options[:check_dev] = value
    end

    add_option("--[no-]user-install",
               "Cleanup in user's home directory instead",
               "of GEM_HOME.") do |value, options|
      options[:user_install] = value
    end

    @candidate_gems  = nil
    @default_gems    = []
    @full            = nil
    @gems_to_cleanup = nil
    @primary_gems    = nil
  end

  def arguments # :nodoc:
    "GEMNAME       name of gem to cleanup"
  end

  def defaults_str # :nodoc:
    "--no-dry-run"
  end

  def description # :nodoc:
    <<-EOF
The cleanup command removes old versions of gems from GEM_HOME that are not
required to meet a dependency.  If a gem is installed elsewhere in GEM_PATH
the cleanup command won't delete it.

If no gems are named all gems in GEM_HOME are cleaned.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} [GEMNAME ...]"
  end

  def execute
    say "Cleaning up installed gems..."

    if options[:args].empty?
      done     = false
      last_set = nil

      until done do
        clean_gems

        this_set = @gems_to_cleanup.map(&:full_name).sort

        done = this_set.empty? || last_set == this_set

        last_set = this_set
      end
    else
      clean_gems
    end

    say "Clean up complete"

    verbose do
      skipped = @default_gems.map(&:full_name)

      "Skipped default gems: #{skipped.join ", "}"
    end
  end

  def clean_gems
    get_primary_gems
    get_candidate_gems
    get_gems_to_cleanup

    @full = Gem::DependencyList.from_specs

    deplist = Gem::DependencyList.new
    @gems_to_cleanup.each {|spec| deplist.add spec }

    deps = deplist.strongly_connected_components.flatten

    deps.reverse_each do |spec|
      uninstall_dep spec
    end
  end

  def get_candidate_gems
    @candidate_gems = if options[:args].empty?
      Gem::Specification.to_a
    else
      options[:args].flat_map do |gem_name|
        Gem::Specification.find_all_by_name gem_name
      end
    end
  end

  def get_gems_to_cleanup
    gems_to_cleanup = @candidate_gems.select do |spec|
      @primary_gems[spec.name].version != spec.version
    end

    default_gems, gems_to_cleanup = gems_to_cleanup.partition(&:default_gem?)

    uninstall_from = options[:user_install] ? Gem.user_dir : Gem.dir

    gems_to_cleanup = gems_to_cleanup.select do |spec|
      spec.base_dir == uninstall_from
    end

    @default_gems += default_gems
    @default_gems.uniq!
    @gems_to_cleanup = gems_to_cleanup.uniq
  end

  def get_primary_gems
    @primary_gems = {}

    Gem::Specification.each do |spec|
      if @primary_gems[spec.name].nil? ||
         @primary_gems[spec.name].version < spec.version
        @primary_gems[spec.name] = spec
      end
    end
  end

  def uninstall_dep(spec)
    return unless @full.ok_to_remove?(spec.full_name, options[:check_dev])

    if options[:dryrun]
      say "Dry Run Mode: Would uninstall #{spec.full_name}"
      return
    end

    say "Attempting to uninstall #{spec.full_name}"

    uninstall_options = {
      executables: false,
      version: "= #{spec.version}",
    }

    uninstall_options[:user_install] = Gem.user_dir == spec.base_dir

    uninstaller = Gem::Uninstaller.new spec.name, uninstall_options

    begin
      uninstaller.uninstall
    rescue Gem::DependencyRemovalException, Gem::InstallError,
           Gem::GemNotInHomeException, Gem::FilePermissionError => e
      say "Unable to uninstall #{spec.full_name}:"
      say "\t#{e.class}: #{e.message}"
    end
  end
end
                                                                                                                                                                                                                                               rubygems/rubygems/commands/cert_command.rb                                                          0000644                 00000022210 15040313420 0015004 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../security"

class Gem::Commands::CertCommand < Gem::Command
  def initialize
    super "cert", "Manage RubyGems certificates and signing settings",
          add: [], remove: [], list: [], build: [], sign: []

    add_option("-a", "--add CERT",
               "Add a trusted certificate.") do |cert_file, options|
      options[:add] << open_cert(cert_file)
    end

    add_option("-l", "--list [FILTER]",
               "List trusted certificates where the",
               "subject contains FILTER") do |filter, options|
      filter ||= ""

      options[:list] << filter
    end

    add_option("-r", "--remove FILTER",
               "Remove trusted certificates where the",
               "subject contains FILTER") do |filter, options|
      options[:remove] << filter
    end

    add_option("-b", "--build EMAIL_ADDR",
               "Build private key and self-signed",
               "certificate for EMAIL_ADDR") do |email_address, options|
      options[:build] << email_address
    end

    add_option("-C", "--certificate CERT",
               "Signing certificate for --sign") do |cert_file, options|
      options[:issuer_cert] = open_cert(cert_file)
      options[:issuer_cert_file] = cert_file
    end

    add_option("-K", "--private-key KEY",
               "Key for --sign or --build") do |key_file, options|
      options[:key] = open_private_key(key_file)
    end

    add_option("-A", "--key-algorithm ALGORITHM",
               "Select which key algorithm to use for --build") do |algorithm, options|
      options[:key_algorithm] = algorithm
    end

    add_option("-s", "--sign CERT",
               "Signs CERT with the key from -K",
               "and the certificate from -C") do |cert_file, options|
      raise Gem::OptionParser::InvalidArgument, "#{cert_file}: does not exist" unless
        File.file? cert_file

      options[:sign] << cert_file
    end

    add_option("-d", "--days NUMBER_OF_DAYS",
               "Days before the certificate expires") do |days, options|
      options[:expiration_length_days] = days.to_i
    end

    add_option("-R", "--re-sign",
               "Re-signs the certificate from -C with the key from -K") do |resign, options|
      options[:resign] = resign
    end
  end

  def add_certificate(certificate) # :nodoc:
    Gem::Security.trust_dir.trust_cert certificate

    say "Added '#{certificate.subject}'"
  end

  def check_openssl
    return if Gem::HAVE_OPENSSL

    alert_error "OpenSSL library is required for the cert command"
    terminate_interaction 1
  end

  def open_cert(certificate_file)
    check_openssl
    OpenSSL::X509::Certificate.new File.read certificate_file
  rescue Errno::ENOENT
    raise Gem::OptionParser::InvalidArgument, "#{certificate_file}: does not exist"
  rescue OpenSSL::X509::CertificateError
    raise Gem::OptionParser::InvalidArgument,
      "#{certificate_file}: invalid X509 certificate"
  end

  def open_private_key(key_file)
    check_openssl
    passphrase = ENV["GEM_PRIVATE_KEY_PASSPHRASE"]
    key = OpenSSL::PKey.read File.read(key_file), passphrase
    raise Gem::OptionParser::InvalidArgument,
      "#{key_file}: private key not found" unless key.private?
    key
  rescue Errno::ENOENT
    raise Gem::OptionParser::InvalidArgument, "#{key_file}: does not exist"
  rescue OpenSSL::PKey::PKeyError, ArgumentError
    raise Gem::OptionParser::InvalidArgument, "#{key_file}: invalid RSA, DSA, or EC key"
  end

  def execute
    check_openssl

    options[:add].each do |certificate|
      add_certificate certificate
    end

    options[:remove].each do |filter|
      remove_certificates_matching filter
    end

    options[:list].each do |filter|
      list_certificates_matching filter
    end

    options[:build].each do |email|
      build email
    end

    if options[:resign]
      re_sign_cert(
        options[:issuer_cert],
        options[:issuer_cert_file],
        options[:key]
      )
    end

    sign_certificates unless options[:sign].empty?
  end

  def build(email)
    unless valid_email?(email)
      raise Gem::CommandLineError, "Invalid email address #{email}"
    end

    key, key_path = build_key
    cert_path = build