OST",
               "Use another gemcutter-compatible host",
               "  (e.g. https://rubygems.org)" do |value, options|
      options[:host] = value
    end
  end

  def execute
    @host = options[:host]

    sign_in(scope: get_owner_scope)
    name = get_one_gem_name

    add_owners    name, options[:add]
    remove_owners name, options[:remove]
    show_owners   name
  end

  def show_owners(name)
    Gem.load_yaml

    response = rubygems_api_request :get, "api/v1/gems/#{name}/owners.yaml" do |request|
      request.add_field "Authorization", api_key
    end

    with_response response do |resp|
      owners = Gem::SafeYAML.load clean_text(resp.body)

      say "Owners for gem: #{name}"
      owners.each do |owner|
        say "- #{owner["email"] || owner["handle"] || owner["id"]}"
      end
    end
  end

  def add_owners(name, owners)
    manage_owners :post, name, owners
  end

  def remove_owners(name, owners)
    manage_owners :delete, name, owners
  end

  def manage_owners(meth