ing executables if it's a default gem.
        options[:only_executables] = true if spec.default_gem?
      end

      if options.key? :skip
        if options[:skip].include? spec.name
          say "Skipped #{spec.full_name}, it was given through options"
          next
        end
      end

      unless spec.extensions.empty? || options[:extensions] || only_executables_or_plugins?
        say "Skipped #{spec.full_name_with_location}, it needs to compile an extension"
        next
      end

      gem = spec.cache_file

      unless File.exist?(gem) || only_executables_or_plugins?
        require_relative "../remote_fetcher"

        say "Cached gem for #{spec.full_name_with_location} not found, attempting to fetch..."

        dep = Gem::Dependency.new spec.name, spec.version
        found, _ = Gem::SpecFetcher.fetcher.spec_for_dependency dep

        if found.empty?
          say "Skipped #{spec.full_name}, it was not found from cache and remote sources"
          next
        end

        spec_candidate, source = found.first
        Gem::RemoteFetcher.fetcher.download spec_candidate, source.uri.to_s, spec.base_dir
      end

      env_shebang =
        if options.include? :env_shebang
          options[:env_shebang]
        else
          install_defaults = Gem::ConfigFile::PLATFORM_DEFAULTS["install"]
          install_defaults.to_s["--env-shebang"]
        end

      bin_dir = options[:bin_dir] if options[:bin_dir]

      installer_options = {
        wrappers: true,
        force: true,
        install_dir: install_dir || spec.base_dir,
        env_shebang: env_shebang,
        build_args: spec.build_args,
        bin_dir: bin_dir,
      }

      if options[:only_executables]
        installer = Gem::Installer.for_spec(spec, installer_options)
        installer.generate_bin
      elsif options[:only_plugins]
        installer = Gem::Installer.for_spec(spec, installer_options)
        installer.generate_plugins
      else
        installer = Gem::Installer.at(gem, installer_options)
        installer.install
      end

      say "Restored #{spec.full_name_with_location}"
    end
  end

  private

  def only_executables_or_plugins?
    options[:only_executables] || options[:only_plugins]
  end
end
                                                                                                                                                                                                                                                                                                                            rubygems/rubygems/commands/environment_command.rb                                                   0000644                 00000012716 15040313420 0016425 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"

class Gem::Commands::EnvironmentCommand < Gem::Command
  def initialize
    super "environment", "Display information about the RubyGems environment"
  end

  def arguments # :nodoc:
    args = <<-EOF
          home            display the path where gems are installed. Aliases: gemhome, gemdir, GEM_HOME
          path            display path used