_man1_dir) { Dir["bundle*.1{,.txt,.ronn}"] }

      remove_file_list(man1_to_remove, old_man1_dir)
    end

    old_man5_dir = "#{old_man_dir}/man5"

    if File.exist?(old_man5_dir)
      man5_to_remove = Dir.chdir(old_man5_dir) { Dir["gemfile.5{,.txt,.ronn}"] }

      remove_file_list(man5_to_remove, old_man5_dir)
    end
  end

  def show_release_notes
    release_notes = File.join Dir.pwd, "CHANGELOG.md"

    release_notes =
      if File.exist? release_notes
        history = File.read release_notes

        history.force_encoding Encoding::UTF_8

        text = history.split(HISTORY_HEADER)
        text.shift # correct an off-by-one generated by split
        version_lines = history.scan(HISTORY_HEADER)
        versions = history.scan(VERSION_MATCHER).flatten.map do |x|
          Gem::Version.new(x)
        end

        history_string = ""

        until versions.length == 0 ||
              versions.shift <= options[:previous_version] do
          history_string += version_lines.shift + text.shift
        end

        history_string
      else
        "Oh-no! Unable to find release notes!"
      end

    say release_notes
  end

  def uninstall_old_gemcutter
    require_relative "../uninstaller"

    ui = Gem::Uninstaller.new("gemcutter", all: true, ignore: true,
                                           version: "< 0.4")
    ui.uninstall
  rescue Gem::InstallError
  end

  def regenerate_binstubs(bindir)
    require_relative "pristine_command"
    say "Regenerating binstubs"

    args = %w[--all --only-executables --silent]
    args << "--bindir=#{bindir}"
    args << "--install-dir=#{default_dir}"

    if options[:env_shebang]
      args << "--env-shebang"
    end

    command = Gem::Commands::PristineCommand.new
    command.invoke(*args)
  end

  def regenerate_plugins(bindir)
    require_relative "pristine_command"
    say "Regenerating plugins"

    args = %w[--all --only-plugins --silent]
    args << "--bindir=#{bindir}"
    args << "--install-dir=#{default_dir}"

    command = Gem::Commands::PristineCommand.new
    command.invoke(*args)
  end

  private

  def default_dir
    prefix = options[:prefix]

    if prefix.empty?
      dir = Gem.default_dir
    else
      dir = prefix
    end

    prepend_destdir_if_present(dir)
  end

  def prepend_destdir_if_present(path)
    destdir = options[:destdir]
    return path if destdir.empty?

    File.join(options[:destdir], path.gsub(/^[a-zA-Z]:/, ""))
  end

  def install_file_list(files, dest_dir)
    files.each do |file|
      install_file file, dest_dir
    end
  end

  def install_file(file, dest_dir)
    dest_file = F