rgs(args, build_args)
        name = "rubygems-generate_index"
        spec = begin
          Gem::Specification.find_by_name(name)
        rescue Gem::LoadError
          require "rubygems/dependency_installer"
          Gem.install(name, Gem::Requirement.default, Gem::DependencyInstaller::DEFAULT_OPTIONS).find {|s| s.name == name }
        end

        # remove the methods defined in this file so that the methods defined in the gem are used instead,
        # and without a method redefinition warning
        %w[description execute invoke_with_build_args].each do |method|
          RubygemsTrampoline.remove_method(method)
        end
        self.class.singleton_class.remove_method(:new)

        spec.activate
        Gem.load_plugin_files spec.matches_for_glob("rubygems_plugin#{Gem.suffix_pattern}")

        self.class.new.invoke_with_build_args(args, build_args)
      end
    end
    private_constant :RubygemsTrampoline

    # remove_method(:initialize) warns, but removing new does not warn
    def self.new
      command = allocate
      command.send(:initialize, "generate_index", "Generates the index files for a gem server directory (requires rubygems-generate_index)")
      command
    end

    prepend(RubygemsTrampoline)
  end
end
                                                                                                                                                                                                                                                                                       rubygems/rubygems/commands/mirror_command.rb                                                        0000644                 00000001163 15040313420 0015365 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"

unless defined? Gem::Commands::MirrorCommand
  class Gem::Commands::MirrorCommand < Gem::Command
    def initialize
      super("mirror", "Mirror all gem files (requires rubygems-mirror)")
      begin
        Gem::Specification.find_by_name("rubygems-mirror").activate
      rescue Gem::LoadError
        # no-op
      end
    end

    def description # :nodoc:
      <<-EOF
The mirror command has been moved to the rubygems-mirror gem.
      EOF
    end

    def execute
      alert_error "Install the rubygems-mirror gem for the mirror command"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                             rubygems/rubygems/commands/check_command.rb                                                         0000644                 00000004455 15040313420 0015137 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../version_option"
require_relative "../validator"
require_relative "../doctor"

class Gem::Commands::CheckCommand < Gem::Command
  include Gem::VersionOption

  def initialize
    super "check", "Check a gem repository for added or missing files",
          alien: true, doctor: false, dry_run: false, gems: true

    add_option("-a", "--[no-]alien",
               'Report "unmanaged" or rogue files in the',
               "gem repository") do |value, options|
      options[:alien] = value
    end

    add_option("--[no-]doctor",
               "Clean up uninstalled gems and broken",
               "specifications") do |value, options|
      options[:doctor] = value
    end

    add_option("--[no-]dry-run",
               "Do not remove files, only report what",
               "would be removed") do |value, options|
      options[:dry_run] = value
    end

    add_option("--[no-]gems",
               "Check installed gems for problems") do |value, options|
      options[:gems] = value
    end

    add_version_option "check"
  end

  def check_gems
    say "Checking gems..."
    say
    gems = begin
             get_all_gem_names
           rescue StandardError
             []
           end

    Gem::Validator.new.alien(gems).sort.each do |key, val|
      if val.empty?
        say "#{key} is error-free" if Gem.configuration.verbose
      else
        say "#{key} has #{val.size} problems"
        val.each do |error_entry|
          say "  #{error_entry.path}:"
          say "    #{error_entry.problem}"
        end
      end
      say
    end
  end

  def doctor
    say "Checking for files from uninstalled gems..."
    say

    Gem.path.each do |gem_repo|
      doctor = Gem::Doctor.new gem_repo, options[:dry_run]
      doctor.doctor
    end
  end

  def execute
    check_gems if options[:gems]
    doctor if options[:doctor]
  end

  def arguments # :nodoc:
    "GEMNAME       name of gem to check"
  end

  def defaults_str # :nodoc:
    "--gems --alien"
  end

  def description # :nodoc:
    <<-EOF
The check command can list and repair problems with installed gems and
specifications and will clean up gems that have been partially uninstalled.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} [OPTIONS] [GEMNAME ...]"
  end
end
                                                                                                                                                                                                                   rubygems/rubygems/commands/outdated_command.rb                                                      0000644                 00000001540 15040313420 0015663 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../local_remote_options"
require_relative "../spec_fetcher"
require_relative "../version_option"

class Gem::Commands::OutdatedCommand < Gem::Command
  include Gem::LocalRemoteOptions
  include Gem::VersionOption

  def initialize
    super "outdated", "Display all gems that need updates"

    add_local_remote_options
    add_platform_option
  end

  def description # :nodoc:
    <<-EOF
The outdated command lists gems you may wish to upgrade to a newer version.

You can check for dependency mismatches using the dependency command and
update the gems with the update or install commands.
    EOF
  end

  def execute
    Gem::Specification.outdated_and_latest_version.each do |spec, remote_version|
      say "#{spec.name} (#{spec.version} < #{remote_version})"
    end
  end
end
                                                                                                                                                                rubygems/rubygems/commands/exec_command.rb                                                          0000644                 00000015717 15040313420 0015011 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"
require_relative "../dependency_installer"
require_relative "../gem_runner"
require_relative "../package"
require_relative "../version_option"

class Gem::Commands::ExecCommand < Gem::Command
  include Gem::VersionOption

  def initialize
    super "exec", "Run a command from a gem", {
      version: Gem::Requirement.default,
    }

    add_version_option
    add_prerelease_option "to be installed"

    add_option "-g", "--gem GEM", "run the executable from the given gem" do |value, options|
      options[:gem_name] = value
    end

    add_option(:"Install/Update", "--conservative",
      "Prefer the most recent installed version, ",
      "rather than the latest version overall") do |_value, options|
      options[:conservative] = true
    end
  end

  def arguments # :nodoc:
    "COMMAND  the executable command to run"
  end

  def defaults_str # :nodoc:
    "--version '#{Gem::Requirement.default}'"
  end

  def description # :nodoc:
    <<-EOF
The exec command handles installing (if necessary) and running an executable
from a gem, regardless of whether that gem is currently installed.

The exec command can be thought of as a shortcut to running `gem install` and
then the executable from the installed gem.

For example, `gem exec rails new .` will run `rails new .` in the current
directory, without having to manually run `gem install rails`.
Additionally, the exec command ensures the most recent version of the gem
is used (unless run with `--conservative`), and that the gem is not installed
to the same gem path as user-installed gems.
    EOF
  end

  def usage # :nodoc:
    "#{program_name} [options --] COMMAND [args]"
  end

  def execute
    check_executable

    print_command
    if options[:gem_name] == "gem" && options[:executable] == "gem"
      set_gem_exec_install_paths
      Gem::GemRunner.new.run options[:args]
      return
    elsif options[:conservative]
      install_if_needed
    else
      install
      activate!
    end

    load!
  end

  private

  def handle_options(args)
    args = add_extra_args(args)
    check_deprecated_options(args)
    @options = Marshal.load Marshal.dump @defaults # deep copy
    parser.order!(args) do |v|
      # put the non-option back at the front of the list of arguments
      args.unshift(v)

      # stop parsing once we hit the first non-option,
      # so you can call `gem exec rails --version` and it prints the rails
      # version rather than rubygem's
      break
    end
    @options[:args] = args

    options[:executable], gem_version = extract_gem_name_and_version(options[:args].shift)
    options[:gem_name] ||= options[:executable]

    if gem_version
      if options[:version].none?
        options[:version] = Gem::Requirement.new(gem_version)
      else
        options[:version].concat [gem_version]
      end
    end

    if options[:prerelease] && !options[:version].prerelease?
      if options[:version].none?
        options[:version] = Gem::Requirement.default_prerelease
      else
        options[:version].concat [Gem::Requirement.default_prerelease]
      end
    end
  end

  def check_executable
    if options[:executable].nil?
      raise Gem::CommandLineError,
        "Please specify an executable to run (e.g. #{program_name} COMMAND)"
    end
  end

  def print_command
    verbose "running #{program_name} with:\n"
    opts = options.reject {|_, v| v.nil? || Array(v).empty? }
    max_length = opts.map {|k, _| k.size }.max
    opts.each do |k, v|
      next if v.nil?
      verbose "\t#{k.to_s.rjust(max_length)}: #{v}"
    end
    verbose ""
  end

  def install_if_needed
    activate!
  rescue Gem::MissingSpecError
    verbose "#{Gem::Dependency.new(options[:gem_name], options[:version])} not available locally, installing from remote"
    install
    activate!
  end

  def set_gem_exec_install_paths
    home = Gem.dir

    ENV["GEM_PATH"] = ([home] + Gem.path).join(File::PATH_SEPARATOR)
    ENV["GEM_HOME"] = home
    Gem.clear_paths
  end

  def install
    set_gem_exec_install_paths

    gem_name = options[:gem_name]
    gem_version = options[:version]

    install_options = options.merge(
      minimal_deps: false,
      wrappers: true
    )

    suppress_always_install do
      dep_installer = Gem::DependencyInstaller.new install_options

      request_set = dep_installer.resolve_dependencies gem_name, gem_version

      verbose "Gems to install:"
      request_set.sorted_requests.each do |activation_request|
        verbose "\t#{activation_request.full_name}"
      end

      request_set.install install_options
    end

    Gem::Specification.reset
  rescue Gem::InstallError => e
    alert_error "Error installing #{gem_name}:\n\t#{e.message}"
    terminate_interaction 1
  rescue Gem::GemNotFoundException => e
    show_lookup_failure e.name, e.version, e.errors, false

    terminate_interaction 2
  rescue Gem::UnsatisfiableDependencyError => e
    show_lookup_failure e.name, e.version, e.errors, false,
                        "'#{gem_name}' (#{gem_version})"

    terminate_interaction 2
  end

  def activate!
    gem(options[:gem_name], options[:version])
    Gem.finish_resolve

    verbose "activated #{options[:gem_name]} (#{Gem.loaded_specs[options[:gem_name]].version})"
  end

  def load!
    argv = ARGV.clone
    ARGV.replace options[:args]

    executable = options[:executable]

    contains_executable = Gem.loaded_specs.values.select do |spec|
      spec.executables.include?(executable)
    end

    if contains_executable.any? {|s| s.name == executable }
      contains_executable.select! {|s| s.name == executable }
    end

    if contains_executable.empty?
      spec = Gem.loaded_specs[executable]

      if spec.nil? || spec.executables.empty?
        alert_error "Failed to load executable `#{executable}`," \
              " are you sure the gem `#{options[:gem_name]}` contains it?"
        terminate_interaction 1
      end

      if spec.executables.size > 1
        alert_error "Ambiguous which executable from gem `#{executable}` should be run: " \
              "the options are #{spec.executables.sort}, specify one via COMMAND, and use `-g` and `-v` to specify gem and version"
        terminate_interaction 1
      end

      contains_executable << spec
      executable = spec.executable
    end

    if contains_executable.size > 1
      alert_error "Ambiguous which gem `#{executable}` should come from: " \
            "the options are #{contains_executable.map(&:name)}, " \
            "specify one via `-g`"
      terminate_interaction 1
    end

    old_exe = $0
    $0 = executable
    load Gem.activate_bin_path(contains_executable.first.name, executable, ">= 0.a")
  ensure
    $0 = old_exe if old_exe
    ARGV.replace argv
  end

  def suppress_always_install
    name = :always_install
    cls = ::Gem::Resolver::InstallerSet
    method = cls.instance_method(name)
    cls.remove_method(name)
    cls.define_method(name) { [] }

    begin
      yield
    ensure
      cls.remove_method(name)
      cls.define_method(name, method)
    end
  end
end
                                                 rubygems/rubygems/commands/setup_command.rb                                                         0000644                 00000043436 15040313420 0015224 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../command"

##
# Installs RubyGems itself.  This command is ordinarily only available from a
# RubyGems checkout or tarball.

class Gem::Commands::SetupCommand < Gem::Command
  HISTORY_HEADER = %r{^#\s*[\d.a-zA-Z]+\s*/\s*\d{4}-\d{2}-\d{2}\s*$}
  VERSION_MATCHER = %r{^#\s*([\d.a-zA-Z]+)\s*/\s*\d{4}-\d{2}-\d{2}\s*$}

  ENV_PATHS = %w[/usr/bin/env /bin/env].freeze

  def initialize
    super "setup", "Install RubyGems",
          format_executable: false, document: %w[ri],
          force: true,
          site_or_vendor: "sitelibdir",
          destdir: "", prefix: "", previous_version: "",
          regenerate_binstubs: true,
          regenerate_plugins: true

    add_option "--previous-version=VERSION",
               "Previous version of RubyGems",
               "Used for changelog processing" do |version, options|
      options[:previous_version] = version
    end

    add_option "--prefix=PREFIX",
               "Prefix path for installing RubyGems",
               "Will not affect gem repository location" do |prefix, options|
      options[:prefix] = File.expand_path prefix
    end

    add_option "--destdir=DESTDIR",
               "Root directory to install RubyGems into",
               "Mainly used for packaging RubyGems" do |destdir, options|
      options[:destdir] = File.expand_path destdir
    end

    add_option "--[no-]vendor",
               "Install into vendorlibdir not sitelibdir" do |vendor, options|
      options[:site_or_vendor] = vendor ? "vendorlibdir" : "sitelibdir"
    end

    add_option "--[no-]format-executable",
               "Makes `gem` match ruby",
               "If Ruby is ruby18, gem will be gem18" do |value, options|
      options[:format_executable] = value
    end

    add_option "--[no-]document [TYPES]", Array,
               "Generate documentation for RubyGems",
               "List the documentation types you wish to",
               "generate.  For example: rdoc,ri" do |value, options|
      options[:document] = case value
                           when nil   then %w[rdoc ri]
                           when false then []
                           else value
      end
    end

    add_option "--[no-]rdoc",
               "Generate RDoc documentation for RubyGems" do |value, options|
      if value
        options[:document] << "rdoc"
      else
        options[:document].delete "rdoc"
      end

      options[:document].uniq!
    end

    add_option "--[no-]ri",
               "Generate RI documentation for RubyGems" do |value, options|
   