# frozen_string_literal: true

require_relative "../command"
require_relative "../local_remote_options"
require_relative "../gemcutter_utilities"
require_relative "../text"

class Gem::Commands::OwnerCommand < Gem::Command
  include Gem::Text
  include Gem::LocalRemoteOptions
  include Gem::GemcutterUtilities

  def description # :nodoc:
    <<-EOF
The owner command lets you add and remove owners of a gem on a push
server (the default is https://rubygems.org). Multiple owners can be
added or removed at the same time, if the flag is given multiple times.

The supported user identifiers are dependent on the push server.
For rubygems.org, both e-mail and handle are supported, even though the
user identifier field is called "email".

The owner of a gem has the permission to push new versions, yank existing
versions or edit the HTML page of the gem.  Be careful of who you give push
permissi