tension_dir

    File.open destination, "wb" do |io|
      io.puts output
    end

    destination
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                   rubygems/rubygems/ext/configure_builder.rb                                                          0000644                 00000001404 15040313420 0015041 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

class Gem::Ext::ConfigureBuilder < Gem::Ext::Builder
  def self.build(extension, dest_path, results, args=[], lib_dir=nil, configure_dir=Dir.pwd,
    target_rbconfig=Gem.target_rbconfig)
    if target_rbconfig.path
      warn "--target-rbconfig is not yet supported for configure-based extensions. Ignoring"
    end

    unless File.exist?(File.join(configure_dir, "Makefile"))
      cmd = ["sh", "./configure", "--prefix=#{dest_path}", *args]

      run cmd, results, class_name, configure_dir
    end

    make dest_path, results, configure_dir, target_rbconfig: target_rbconfig

    results
  end
end
                                                                                                                                                                                                                                                            rubygems/rubygems/ext/ext_conf_builder.rb                                                           0000644                 00000005067 15040313420 0014676 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

class Gem::Ext::ExtConfBuilder < Gem::Ext::Builder
  def self.build(extension, dest_path, results, args=[], lib_dir=nil, extension_dir=Dir.pwd,
    target_rbconfig=Gem.target_rbconfig)
    require "fileutils"
    require "tempfile"

    tmp_dest = Dir.mktmpdir(".gem.", extension_dir)

    # Some versions of `mktmpdir` return absolute paths, which will break make
    # if the paths contain spaces.
    #
    # As such, we convert to a relative path.
    tmp_dest_relative = get_relative_path(tmp_dest.clone, extension_dir)

    destdir = ENV["DESTDIR"]

    begin
      cmd = ruby << File.basename(extension)
      cmd << "--target-rbconfig=#{target_rbconfig.path}" if target_rbconfig.path
      cmd.push(*args)

      run(cmd, results, class_name, extension_dir) do |s, r|
        mkmf_log = File.join(extension_dir, "mkmf.log")
        if File.exist? mkmf_log
          unless s.success?
            r << "To see why this extension failed to compile, please check" \
              " the mkmf.log which can be found here:\n"
            r << "  " + File.join(dest_path, "mkmf.log") + "\n"
          end
          FileUtils.mv mkmf_log, dest_path
        end
      end

      ENV["DESTDIR"] = nil

      make dest_path, results, extension_dir, tmp_dest_relative, target_rbconfig: target_rbconfig

      full_tmp_dest = File.join(extension_dir, tmp_dest_relative)

      is_cross_compiling = target_rbconfig["platform"] != RbConfig::CONFIG["platform"]
      # Do not copy extension libraries by default when cross-compiling
      # not to conflict with the one already built for the host platform.
      if Gem.install_extension_in_lib && lib_dir && !is_cross_compiling
        FileUtils.mkdir_p lib_dir
        entries = Dir.entries(full_tmp_dest) - %w[. ..]
        entries = entries.map {|entry| File.join full_tmp_dest, entry }