-" * 78
      say
    end

    if options[:previous_version].empty?
      options[:previous_version] = Gem::VERSION.sub(/[0-9]+$/, "0")
    end

    options[:previous_version] = Gem::Version.new(options[:previous_version])

    show_release_notes

    say
    say "-" * 78
    say

    say "RubyGems installed the following executables:"
    say bin_file_names.map {|name| "\t#{name}\n" }
    say

    unless bin_file_names.grep(/#{File::SEPARATOR}gem$/)
      say "If `gem` was installed by a previous RubyGems installation, you may need"
      say "to remove it by hand."
      say
    end

    if documentation_success
      if options[:document].include? "rdoc"
        say "Rdoc documentation was installed. You may now invoke:"
        say "  gem server"
        say "and then peruse beautifully formatted documentation for your gems"
        say "with your web browser."
        say "If you do not wish to install this documentation in the future, use the"
        say "--no-document flag, or set it as the default in your ~/.gemrc file. See"
        say "'gem help env' for details."
        say
      end

      if options[:document].include? "ri"
        say "Ruby Interactive (ri) documentation was installed. ri is kind of like man "
        say "pages for Ruby libraries. You may access it like this:"
        say "  ri Classname"
        say "  ri Classname.class_method"
        say "  ri Classname#instance_method"
        say "If you do not wish to install this documentation in the future, use the"
        say "--no-document flag, or set it as the default in your ~/.gemrc file. See"
        say "'gem help env' for details."
        say
      end
    end
  end

  def install_executables(bin_dir)
    prog_mode = options[:prog_mode] || 0o755

    executables = { "gem" => "exe" }
    executables.each do |tool, path|
      say "Installing #{tool} executable" if @verbose

      Dir.chdir path do
        bin_file = "gem"

        require "tmpdir"

        dest_file = target_bin_path(bin_dir, bin_file)
        bin_tmp_file = File.join Dir.tmpdir, "#{bin_file}.#{$$}"

        begin
          bin = File.readlines bin_file
          bin[0] = shebang

          File.open bin_tmp_file, "w" do |fp|
            fp.puts bin.join
          end

          install bin_tmp_file, dest_file, mode: prog_mode
          bin_file_names << dest_file
        ensure
          rm bin_tmp_file
        end

        next unless Gem.win_platform?

        begin
          bin_cmd_file = File.join Dir.tmpdir, "#{bin_file}.bat"

          File.open bin_cmd_file, "w" do |file|
            file.puts <<-TEXT
  @ECHO OFF
  @"%~dp0#{File.basename(Gem.ruby).chomp('"')}" "%~dpn0" %*
  TEXT
          end

          install bin_cmd_file, "#{dest_file}.bat", mode: prog_mode
        ensure
          rm bin_cmd_file
        end
      end
    end
  end

  def shebang
    if options[:env_shebang]
      ruby_name = RbConfig::CONFIG["ruby_install_name"]
      @env_path ||= ENV_PATHS.find {|env_path| File.executable? env_path }
      "#!#{@env_path} #{ruby_name}\n"
    else
      "#!#{Gem.ruby}\n"
    end
  end

  def install_lib(lib_dir)
    libs = { "RubyGems" => "lib" }
    libs["Bundler"] = "bundler/lib"
    libs.each do |tool, path|
      say "Installing #{tool}" if @verbose

      lib_files = files_in path

      Dir.chdir path do
        install_file_list(lib_files, lib_dir)
      end
    end
  end

  def install_rdoc
    gem_doc_dir = File.join Gem.dir, "doc"
    rubygems_name = "rubygems-#{Gem::VERSION}"
    rubygems_doc_dir = File.join gem_doc_dir, rubygems_name

    begin
      Gem.ensure_gem_subdirectories Gem.dir
    rescue SystemCallError
      # ignore
    end

    if File.writable?(gem_doc_dir) &&
       (!File.exist?(rubygems_doc_dir) ||
        File.writable?(rubygems_doc_dir))
      say "Removing old RubyGems RDoc and ri" if @verbose
      Dir[File.join(Gem.dir, "doc", "rubygems-[0-9]*")].each do |dir|
        rm_rf dir
      end

      require_relative "../rdoc"

      return false unless defined?(Gem::RDoc)

      fake_spec = Gem::Specification.new "rubygems", Gem::VERSION
      def fake_spec.full_gem_path
        File.expand_path "../../..", __dir__
      end

      generate_ri   = options[:document].include? "ri"
      generate_rdoc = options[:document].include? "rdoc"

      rdoc = Gem::RDoc.new fake_spec, generate_rdoc, generate_ri
      rdoc.generate

      return true
    elsif @verbose
      say "Skipping RDoc generation, #{gem_doc_dir} not writable"
      say "Set the GEM_HOME environment variable if you want RDoc generated"
    end

    false
  end

  def install_default_bundler_gem(bin_dir)
    current_default_spec = Gem::Specification.default_stubs.find {|s| s.name == "bundler" }
    specs_dir = if current_default_spec && default_dir == Gem.default_dir
      all_specs_current_version = Gem::Specification.stubs.select {|s| s.full_name == current_default_spec.full_name }

      Gem::Specification.remove_spec current_default_spec
      loaded_from = current_default_spec.loaded_from
      File.delete(loaded_from)

      # Remove previous default gem executables if they were not shadowed by a regular gem
      FileUtils.rm_rf current_default_spec.full_gem_path if all_specs_current_version.size == 1

      File.dirname(loaded_from)
    else
      target_specs_dir = File.join(default_dir, "specifications", "default")
      mkdir_p target_specs_dir, mode: 0o755
      target_specs_dir
    end

    new_bundler_spec = Dir.chdir("bundler") { Gem::Specification.load("bundler.gemspec") }
    full_name = new_bundler_spec.full_name
    gemspec_path = "#{full_name}.gemspec"

    default_spec_path = File.join(specs_dir, gemspec_path)
    Gem.write_binary(default_spec_path, new_bundler_spec.to_ruby)

    bundler_spec = Gem::Specification.load(default_spec_path)

    # Remove gemspec that was same version of vendored bundler.
    normal_gemspec = File.join(default_dir, "specifications", gemspec_path)
    if File.file? normal_gemspec
      File.delete normal_gemspec
    end

    # Remove gem files that were same version of vendored bundler.
    if File.directory? bundler_spec.gems_dir
      Dir.entries(bundler_spec.gems_dir).
        select {|default_gem| File.basename(default_gem) == full_name }.
        each {|default_gem| rm_r File.join(bundler_spec.gems_dir, default_gem) }
    end

    require_relative "../installer"

    Dir.chdir("bundler") do
      built_gem = Gem::Package.build(new_bundler_spec)
      begin
        Gem::Installer.at(
          built_gem,
          env_shebang: options[:env_shebang],
          format_executable: options[:format_executable],
          force: options[:force],
          install_as_default: true,
          bin_dir: bin_dir,
          install_dir: default_dir,
          wrappers: true
        ).install
      ensure
        FileUtils.rm_f built_gem
      end
    end

    new_bundler_spec.executables.each {|executable| bin_file_names << target_bin_path(bin_dir, executable) }

    say "Bundler #{new_bundler_spec.version} installed"
  end

  def make_destination_dirs
    lib_dir, bin_dir = Gem.default_rubygems_dirs

    unless lib_dir
      lib_dir, bin_dir = generate_default_dirs
    end

    mkdir_p lib_dir, mode: 0o755
    mkdir_p bin_dir, mode: 0o755

    [lib_dir, bin_dir]
  end

  def generate_default_man_dir
    prefix = options[:prefix]

    if prefix.empty?
      man_dir = RbConfig::CONFIG["mandir"]
      return unless man_dir
    else
      man_dir = File.join prefix, "man"
    end

    prepend_destdir_if_present(man_dir)
  end

  def generate_default_dirs
    prefix = options[:prefix]
    site_or_vendor = options[:site_or_vendor]

    if prefix.empty?
      lib_dir = RbConfig::CONFIG[site_or_vendor]
      bin_dir = RbConfig::CONFIG["bindir"]
    else
      lib_dir = File.join prefix, "lib"
      bin_dir = File.join prefix, "bin"
    end

    [prepend_destdir_if_present(lib_dir), prepend_destdir_if_present(bin_dir)]
  end

  def files_in(dir)
    Dir.chdir dir do
      Dir.glob(File.join("**", "*"), File::FNM_DOTMATCH).
        select {|f| !File.directory?(f) }
    end
  end

  def remove_old_bin_files(bin_dir)
    old_bin_files = {
      "gem_mirror" => "gem mirror",
      "gem_server" => "gem server",
      "gemlock" => "gem lock",
      "gemri" => "ri",
      "gemwhich" => "gem which",
      "index_gem_repository.rb" => "gem generate_index",
    }

    old_bin_files.each do |old_bin_file, new_name|
      old_bin_path = File.join bin_dir, old_bin_file
      next unless File.exist? old_bin_path

      deprecation_message = "`#{old_bin_file}` has been deprecated. Use `#{new_name}` instead."

      File.open old_bin_path, "w" do |fp|
        fp.write <<-EOF
#!#{Gem.ruby}

abort "#{deprecation_message}"
    EOF
      end

      next unless Gem.win_platform?

      File.open "#{old_bin_path}.bat", "w" do |fp|
        fp.puts %(@ECHO.#{deprecation_message})
      end
    end
  end

  def remove_old_lib_files(lib_dir)
    lib_dirs = { File.join(lib_dir, "rubygems") => "lib/rubygems" }
    lib_dirs[File.join(lib_dir, "bundler