I for that server.

If you are packaging RubyGems all of RubyGems' defaults are in
lib/rubygems/defaults.rb.  You may override these in
lib/rubygems/defaults/operating_system.rb
    EOF
  end

  def usage # :nodoc:
    "#{program_name} [arg]"
  end

  def execute
    out = String.new
    arg = options[:args][0]
    out <<
      case arg
      when /^version/ then
        Gem::VERSION
      when /^gemdir/, /^gemhome/, /^home/, /^GEM_HOME/ then
        Gem.dir
      when /^gempath/, /^path/, /^GEM_PATH/ then
        Gem.path.join(File::PATH_SEPARATOR)
      when /^user_gemdir/, /^user_gemhome/ then
        Gem.user_dir
      when /^remotesources/ then
        Gem.sources.to_a.join("\n")
      when /^platform/ then
        Gem.platforms.join(File::PATH_SEPARATOR)
      when /^credentials/, /^creds/ then
        Gem.configuration.credentials_path
      when nil then
        show_environment
      else
        raise Gem::CommandLineError, "Unknown environment option [#{arg}]"
      end
    say out
    true
  end

  def add_path(out, path)
    path.each do |component|
      out << "     - #{component}\n"
    end
  end

  def show_environment # :nodoc:
    out = "RubyGems Environment:\n".dup

    out << "  - RUBYGEMS VERSION: #{Gem::VERSION}\n"

    out << "  - RUBY VERSION: #{RUBY_VERSION} (#{RUBY_RELEASE_DATE} patchlevel #{RUBY_PATCHLEVEL}) [#{RUBY_PLATFORM}]\n"

    out << "  - INSTALLATION DIRECTORY: #{Gem.dir}\n"

    out << "  - USER INSTALLATION DIRECTORY: #{Gem.user_dir}\n"

    out << "  - CREDENTIALS FILE: #{Gem.configuration.credentials_path}\n"

    out << "  - RUBYGEMS PREFIX: #{Gem.prefix}\n" unless Gem.prefix.nil?

    out << "  - RUBY EXECUTABLE: #{Gem.ruby}\n"

    out << "  - GIT EXECUTABLE: #{git_path}\n"

    out << "  - EXECUTABLE DIRECTORY: #{Gem.bindir}\n"

    out << "  - SPEC CACHE DIRECTORY: #{Gem.spec_cache_dir}\n"

    out << "  - SYSTEM CONFIGURATION DIRECTORY: #{Gem::ConfigFile::SYSTEM_CONFIG_PATH}\n"

    out << "  - RUBYGEMS PLATFORMS:\n"
    Gem.platforms.each do |platform|
      out << "     - #{platform}\n"
    end

    out << "  - GEM PATHS:\n"
    out << "     - #{Gem.dir}\n"

 