
  def development_dependencies
    dependencies.select {|d| d.type == :development }
  end

  ##
  # Returns the full path to this spec's documentation directory.  If +type+
  # is given it will be appended to the end.  For example:
  #
  #   spec.doc_dir      # => "/path/to/gem_repo/doc/a-1"
  #
  #   spec.doc_dir 'ri' # => "/path/to/gem_repo/doc/a-1/ri"

  def doc_dir(type = nil)
    @doc_dir ||= File.join base_dir, "doc", full_name

    if type
      File.join @doc_dir, type
    else
      @doc_dir
    end
  end

  def encode_with(coder) # :nodoc:
    coder.add "name", @name
    coder.add "version", @version
    coder.add "platform", platform.to_s
    coder.add "original_platform", original_platform.to_s if platform.to_s != original_platform.to_s

    attributes = @@attributes.map(&:to_s) - %w[name version platform]
    attributes.each do |name|
      value = instance_variable_get("@#{name}")
      coder.add name, value unless value.nil?
    end
  end

  def eql?(other) # :nodoc:
    self.class === other && 