s to speed up RubyGems

      if Gem::Specification.find_active_stub_by_path(path)
        next
      end

      # Attempt to find +path+ in any unresolved gems...

      found_specs = Gem::Specification.find_in_unresolved path

      # If there are no directly unresolved gems, then try and find +path+
      # in any gems that are available via the currently unresolved gems.
      # For example, given:
      #
      #   a => b => c => d
      #
      # If a and b are currently active with c being unresolved and d.rb is
      # requested, then find_in_unresolved_tree will find d.rb in d because
      # it's a dependency of c.
      #
      if found_specs.empty?
        found_specs = Gem::Specification.find_in_unresolved_tree path

        found_specs.each(&:activate)

      # We found +path+ directly in an unresolved gem. Now we figure out, of
      # the possible found specs, which one we should activate.
      else

        # Check that all the found specs are just different
        # versions of the same gem
        names = found_specs.map(&:name).uniq

        if names.size > 1
          raise Gem::LoadError, "#{path} found in multiple gems: #{names.join ", "}"
        end

        # Ok, now find a gem that has no conflicts, starting
        # at the highest version.
        valid = found_specs.find {|s| !s.has_conflicts? }

        unless valid
          le = Gem::LoadError.new "unable to find a version of '#{names.first}' to activate"
          le.name = names.first
          raise le
        end

        valid.activate
      end
    end

    begin
      gem_original_require(path)
    rescue LoadError => load_error
      if load_error.path == path &&
         RUBYGEMS_ACTIVATION_MONITOR.synchronize { Gem.try_activate(path) }

        return gem_original_require(path)
      end

      raise load_error
    end
  end

  private :require
end
                                                                                                                                                                             rubygems/rubygems/core_ext/kernel_gem.rb                                                            0000644                 00000004304 15040313421 0014475 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Kernel
  ##
  # Use Kernel#gem to activate a specific version of +gem_name+.
  #
  # +requirements+ is a list of version requirements that the
  # specified gem must match, most commonly "= example.version.number".  See
  # Gem::Requirement for how to specify a version requirement.
  #
  # If you will be activating the latest version of a gem, there is no need to
  # call Kernel#gem, Kernel#require will do the right thing for you.
  #
  # Kernel#gem returns true if the gem was activated, otherwise false.  If the
  # gem could not be found, didn't match the version requirements, or a
  # different version was already activated, an exception will be raised.
  #
  # Kernel#gem should be called *before* any require statements (otherwise
  # RubyGems may load a conflicting library version).
  #
  # Kernel#gem only loads prerelease versions when prerelease +requirements+
  # are given:
  #
  #   gem 'rake', '>= 1.1.a', '< 2'
  #
  # In older RubyGems versions, the environment variable GEM_SKIP could be
  # used to skip activation of specified gems, for example to test out changes
  # that haven't been installed yet.  Now RubyGems defers to -I and the
  # RUBYLIB environment variable to skip activation of a gem.
  #
  # Example:
  #
  #   GEM_SKIP=libA:libB ruby -I../libA -I../libB ./mycode.rb

  def gem(gem_name, *requirements) # :doc:
    skip_list = (ENV["GEM_SKIP"] || "").split(/:/)
    raise Gem::LoadError, "skipping #{gem_name}" if skip_list.include? gem_name

    if gem_name.is_a? Gem::Dependency
      unless Gem::Deprecate.skip
        warn "#{Gem.location_of_caller.join ":"}:Warning: Kernel.gem no longer "\
          "accepts a Gem::Dependency object, please pass the name "\
          "and requirements directly"
      end

      requirements = gem_name.requirement
      gem_name = gem_name.name
    end

    dep = Gem::Dependency.new(gem_name, *requirements)

    loaded = Gem.loaded_specs[gem_name]

    return false if loaded && dep.matches_spec?(loaded)

    spec = dep.to_spec

    if spec
      if Gem::LOADED_SPECS_MUTEX.owned?
        spec.activate
      else
        Gem::LOADED_SPECS_MUTEX.synchronize { spec.activate }
      end
    end
  end

  private :gem
end
                                                                                                                                                                                                                                                                                                                            rubygems/rubygems/core_ext/kernel_warn.rb                                                           0000644                 00000001724 15040313422 0014700 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Kernel
  rubygems_path = "#{__dir__}/" # Frames to be skipped start with this path.

  original_warn = instance_method(:warn)

  remove_method :warn

  class << self
    remove_method :warn
  end

  module_function define_method(:warn) {|*messages, **kw|
    unless uplevel = kw[:uplevel]
      return original_warn.bind_call(self, *messages, **kw)
    end

    # Ensure `uplevel` fits a `long`
    uplevel, = [uplevel].pack("l!").unpack("l!")

    if uplevel >= 0
      start = 0
      while uplevel >= 0
        loc, = caller_locations(start, 1)
        unless loc
          # No more backtrace
          start += uplevel
          break
        end

        start += 1

        next unless path = loc.path
        unless path.start_with?(rubygems_path, "<internal:")
          # Non-rubygems frames
          uplevel -= 1
        end
      end
      kw[:uplevel] = start
    end

    original_warn.bind_call(self, *messages, **kw)
  }
end
                                            rubygems/rubygems/source/specific_file.rb                                                           0000644                 00000003013 15040313422 0014636 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A source representing a single .gem file.  This is used for installation of
# local gems.

class Gem::Source::SpecificFile < Gem::Source
  ##
  # The path to the gem for this specific file.

  attr_reader :path

  ##
  # Creates a new SpecificFile for the gem in +file+

  def initialize(file)
    @uri = nil
    @path = ::File.expand_path(file)

    @package = Gem::Package.new @path
    @spec = @package.spec
    @name = @spec.name_tuple
  end

  ##
  # The Gem::Specification extracted from this .gem.

  attr_reader :spec

  def load_specs(*a) # :nodoc:
    [@name]
  end

  def fetch_spec(name) # :nodoc:
    return @spec if name == @name
    raise Gem::Exception, "Unable to find '#{name}'"
  end

  def download(spec, dir = nil) # :nodoc:
    return @path if spec == @spec
    raise Gem::Exception, "Unable to download '#{spec.full_name}'"
  end

  def pretty_print(q) # :nodoc:
    q.object_group(self) do
      q.group 2, "[SpecificFile:", "]" do
        q.breakable
        q.text @path
      end
    end
  end

  ##
  # Orders this source against +other+.
  #
  # If +other+ is a SpecificFile from a different gem name +nil+ is returned.
  #
  # If +other+ is a SpecificFile from the same gem name the versions are
  # compared using Gem::Version#<=>
  #
  # Otherwise Gem::Source#<=> is used.

  def <=>(other)
    case other
    when Gem::Source::SpecificFile then
      return nil if @spec.name != other.spec.name

      @spec.version <=> other.spec.version
    else
      super
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/source/git.rb                                                                     0000644                 00000012663 15040313422 0012650 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A git gem for use in a gem dependencies file.
#
# Example:
#
#   source =
#     Gem::Source::Git.new 'rake', 'git@example:rake.git', 'rake-10.1.0', false
#
#   source.specs

class Gem::Source::Git < Gem::Source
  ##
  # The name of the gem created by this git gem.

  attr_reader :name

  ##
  # The commit reference used for checking out this git gem.

  attr_reader :reference

  ##
  # When false the cache for this repository will not be updated.

  attr_accessor :remote

  ##
  # The git repository this gem is sourced from.

  attr_reader :repository

  ##
  # The directory for cache and git gem installation

  attr_accessor :root_dir

  ##
  # Does this repository need submodules checked out too?

  attr_reader :need_submodules

  ##
  # Creates a new git gem source for a gems from loaded from +repository+ at
  # the given +reference+.  The +name+ is only used to track the repository
  # back to a gem dependencies file, it has no real significance as a git
  # repository may contain multiple gems.  If +submodules+ is true, submodules
  # will be checked out when the gem is installed.

  def initialize(name, repository, reference, submodules = false)
    require_relative "../uri"
    @uri = Gem::Uri.parse(repository)
    @name            = name
    @repository      = repository
    @reference       = reference || "HEAD"
    @need_submodules = submodules

    @remote   = true
    @root_dir = Gem.dir
  end

  def <=>(other)
    case other
    when Gem::Source::Git then
      0
    when Gem::Source::Vendor,
         Gem::Source::Lock then
      -1
    when Gem::Source then
      1
    end
  end

  def ==(other) # :nodoc:
    super &&
      @name            == other.name &&
      @repository      == other.repository &&
      @reference       == other.reference &&
      @need_submodules == other.need_submodules
  end

  def git_command
    ENV.fetch("git", "git")
  end

  ##
  # Checks out the files for the repository into the install_dir.

  def checkout # :nodoc:
    cache

    return false unless File.exist? repo_cache_dir

    unless File.exist? install_dir
      system git_command, "clone", "--quiet", "--no-checkout",
             repo_cache_dir, install_dir
    end

    Dir.chdir install_dir do
      system git_command, "fetch", "--quiet", "--force", "--tags", install_dir

      success = system git_command, "reset", "--quiet", "--hard", rev_parse

      if @need_submodules
        require "open3"
        _, status = Open3.capture2e(git_command, "submodule", "update", "--quiet", "--init", "--recursive")

        success &&= status.success?
      end

      success
    end
  end

  ##
  # Creates a local cache repository for the git gem.

  def cache # :nodoc:
    return unless @remote

    if File.exist? repo_cache_dir
      Dir.chdir repo_cache_dir do
        system git_command, "fetch", "--quiet", "--force", "--tags",
               @repository, "refs/heads/*:refs/heads/*"
      end
    else
      system git_command, "clone", "--quiet", "--bare", "--no-hardlinks",
             @repository, repo_cache_dir
    end
  end

  ##
  # Directory where git gems get unpacked and so-forth.

  def base_dir # :nodoc:
    File.join @root_dir, "bundler"
  end

  ##
  # A short reference for use in git gem directories

  def dir_shortref # :nodoc:
    rev_parse[0..11]
  end

  ##
  # Nothing to download for git gems

  def download(full_spec, path) # :nodoc:
  end

  ##
  # The directory where the git gem will be installed.

  def install_dir # :nodoc:
    return unless File.exist? repo_cache_dir

    File.join base_dir, "gems", "#{@name}-#{dir_shortref}"
  end

  def pretty_print(q) # :nodoc:
    q.object_group(self) do
      q.group 2, "[Git: ", "]" do
        q.breakable
        q.text @repository

        q.breakable
        q.text @reference
      end
    end
  end

  ##
  # The directory where the git gem's repository will be cached.

  def repo_cache_dir # :nodoc:
    File.join @root_dir, "cache", "bundler", "git", "#{@name}-#{uri_hash}"
  end

  ##
  # Converts the git reference for the repository into a commit hash.

  def rev_parse # :nodoc:
    hash = nil

    Dir.chdir repo_cache_dir do
      hash = Gem::Util.popen(git_command, "rev-parse", @reference).strip
    end

    raise Gem::Exception,
          "unable to find reference #{@reference} in #{@repository}" unless
            $?.success?

    hash
  end

  ##
  # Loads all gemspecs in the repository

  def specs
    checkout

    return [] unless install_dir

    Dir.chdir install_dir do
      Dir["{,*,*/*}.gemspec"].filter_map do |spec_file|
        directory = Fi