c, "wb" do |io|
        io.write spec
      end
    end

    Gem.load_safe_marshal
    # TODO: Investigate setting Gem::Specification#loaded_from to a URI
    Gem::SafeMarshal.safe_load spec
  end

  ##
  # Loads +type+ kind of specs fetching from +@uri+ if the on-disk cache is
  # out of date.
  #
  # +type+ is one of the following:
  #
  # :released   => Return the list of all released specs
  # :latest     => Return the list of only the highest version of each gem
  # :prerelease => Return the list of all prerelease only specs
  #

  def load_specs(type)
    file       = FILES[type]
    fetcher    = Gem::RemoteFetcher.fetcher
    file_name  = "#{file}.#{Gem.marshal_version}"
    spec_path  = enforce_trailing_slash(uri) + "#{file_name}.gz"
    cache_dir  = cache_dir spec_path
    local_file = File.join(cache_dir, file_name)
    retried    = false

    if update_cache?
      require "fileutils"
      FileUtils.mkdir_p cache_dir
    end

    spec_dump = fetcher.cache_update_path spec_path, local_file, update_cache?

    Gem.load_safe_marshal
    begin
      Gem::NameTuple.from_list Gem::SafeMarshal.safe_load(spec_dump)
    rescue ArgumentError
      if update_cache? && !retried
        FileUtils.rm local_file
        retried = true
        retry
      else
        raise Gem::Exception.new("Invalid spec cache file in #{local_file}")
      end
    end
  end

  ##
  # Downloads +spec+ and writes it to +dir+.  See also
  # Gem::RemoteFetcher#download.

  def download(spec, dir=Dir.pwd)
    fetcher = Gem::RemoteFetcher.fetcher
    fetcher.download spec, uri.to_s, dir
  end

  def pretty_print(q) # :nodoc:
    q.object_group(self) do
      q.group 2, "[Remote:", "]" do
        q.breakable
        q.text @uri.to_s

        if api = uri
          q.breakable
          q.text "API URI: "
          q.text api.to_s
        end
      end
    end
  end

  def typo_squatting?(host, distance_threshold=4)
    return if @uri.host.nil?
    levenshtein_distance(@uri.host, host).between? 1, distance_threshold
  end

  private

  def enforce_trailing_slash(uri)
    uri.merge(uri.path.gsub(%r{/+$}, "") + "/")
  end
end

require_relative "source/git"
require_relative "source/installed"
require_relative "source/specific_file"
require