  end

    @set.sets << set
  end

  def parse_PLATFORMS # :nodoc:
    while !@tokens.empty? && peek.first == :text do
      name = get(:text).value

      @platforms << name

      skip :newline
    end
  end

  ##
  # Parses the requirements following the dependency +name+ and the +op+ for
  # the first token of the requirements and returns a Gem::Dependency object.

  def parse_dependency(name, op) # :nodoc:
    return Gem::Dependency.new name, op unless peek[0] == :text

    version = get(:text).value

    requirements = ["#{op} #{version}"]

    while peek.type == :comma do
      get :comma
      op      = get(:requirement).value
      version = get(:text).value

      requirements << "#{op} #{version}"
    end

    Gem::Dependency.new name, requirements
  end

  private

  def skip(type) # :nodoc:
    @tokens.skip type
  end

  ##
  # Peeks at the next token for Lockfile

  def peek # :nodoc:
    @tokens.peek
  end

  def pinned_requirement(name) # :nodoc:
    requirement = Gem::Dependency.new name
    specification = @set.sets.flat_map do |set|
      set.find_all(requirement)
    end.compact.first

    specification&.version
  end

  ##
  # Ungets the last token retrieved by #get

  def unget(token) # :nodoc:
    @tokens.unshift token
  end
end
                                                                                                                                                                                                                                                                        rubygems/rubygems/source.rb                                                                         0000644                 00000013442 15040313421 0012060 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "text"
##
# A Source knows how to list and fetch gems from a RubyGems marshal index.
#
# There are other Source subclasses for installed gems, local gems, the
# bundler dependency API and so-forth.

class Gem::Source
  include Comparable
  include Gem::Text

  FILES = { # :nodoc:
    released: "specs",
    latest: "latest_specs",
    prerelease: "prerelease_specs",
  }.freeze

  ##
  # The URI this source will fetch gems from.

  attr_reader :uri

  ##
  # Creates a new Source which will use the index located at +uri+.

  def initialize(uri)
    require_relative "uri"
    @uri = Gem::Uri.parse!(uri)
    @update_cache = nil
  end

  ##
  # Sources are ordered by installation preference.

  def <=>(other)
    case other
    when Gem::Source::Installed,
         Gem::Source::Local,
         Gem::Source::Lock,
         Gem::Source::SpecificFile,
         Gem::Source::Git,
         Gem::Source::Vendor then
      -1
    when Gem::Source then
      unless @uri
        return 0 unless other.uri
        return 1
      end

      return -1 unless other.uri

      # Returning 1 here ensures that when sorting a list of sources, the
      # original ordering of sources supplied by the user is preserved.
      return 1 unless @uri.to_s == other.uri.to_s

      0
    end
  end

  def ==(other) # :nodoc:
    self.class === other && @uri == other.uri
  end

  alias_method :eql?, :== # :nodoc:

  ##
  # Returns a Set that can fetch specifications from this source.

  def dependency_resolver_set # :nodoc:
    return Gem::Resolver::IndexSet.new self if uri.scheme == "file"

    fetch_uri = if uri.host == "rubygems.org"
      index_uri = uri.dup
      index_uri.host = "index.rubygems.org"
      index_uri
    else
      uri
    end

    bundler_api_uri = enforce_trailing_slash(fetch_uri) + "versions"

    begin
      fetcher = Gem::RemoteFetcher.fetcher
      response = fetcher.fetch_path bundler_api_uri, nil, true
    rescue Gem::RemoteFetcher::FetchError
      Gem::Resolver::IndexSet.new self
    else
      Gem::Resolver::APISet.new response.uri + "./info/"
    end
  end

  def hash # :nodoc:
    @uri.hash
  end

  ##
  # Returns the local directory to write +uri+ to.

  def cache_dir(uri)
    # Correct for windows paths
    escaped_path = uri.path.sub(%r{^/([a-z]):/}i, '/\\1-/')

    File.join Gem.spec_cache_dir, "#{uri.host}%#{uri.port}", File.dirname(escaped_path)
  end

  ##
  # Returns true when it is possible and safe to update the cache directory.

  def update_cache?
    return @update_cache unless @update_cache.nil?
    @update_cache =
      begin
        File.stat(Gem.user_home).uid == Process.uid
      rescue Errno::ENOENT
        false
      end
  end

  ##
  # Fetches a specification for the given +name_tuple+.

  def fetch_spec(name_tuple)
    fetcher = Gem::RemoteFetcher.fetcher

    spec_file_name = name_tuple.spec_name

    source_uri = enforce_trailing_slash(uri) + "#{Gem::MARSHAL_SPEC_DIR}#{spec_file_name}"

    cache_dir = cache_dir source_ur