# frozen_string_literal: true

##
# The SourceList represents the sources rubygems has been configured to use.
# A source may be created from an array of sources:
#
#   Gem::SourceList.from %w[https://rubygems.example https://internal.example]
#
# Or by adding them:
#
#   sources = Gem::SourceList.new
#   sources << 'https://rubygems.example'
#
# The most common way to get a SourceList is Gem.sources.

class Gem::SourceList
  include Enumerable

  ##
  # Creates a new SourceList

  def initialize
    @sources = []
  end

  ##
  # The sources in this list

  attr_reader :sources

  ##
  # Creates a new SourceList from an array of sources.

  def self.from(ary)
    list = new

    list.replace ary

    list
  end

  def initialize_copy(other) # :nodoc:
    @sources = @sources.dup
  end

  ##
  # Appends +obj+ to the source list which may be a Gem::Source, Gem::URI or URI
  # String.

  def <<(obj)
    src = case obj
          when Gem::Source
            obj
          else
            Gem::Source.new(obj)
    end

    @sources << src unless @sources.include?(src)
    src
  end

  ##
  # Replaces this SourceList with the source