          digest.class.name[/::([^:]+)\z/, 1]
        end

      digest_name == signer.digest_name
    end

    raise "no #{signer.digest_name} in #{digests.values.compact}" unless signature_digest

    if signer.key
      signature = signer.sign signature_digest.digest

      add_file_simple "#{name}.sig", 0o444, signature.length do |io|
        io.write signature
      end
    end

    digests
  end

  ##
  # Add file +name+ with permissions +mode+ +size+ bytes long.  Yields an IO
  # to write the file to.

  def add_file_simple(name, mode, size) # :yields: io
    check_closed

    name, prefix = split_name name

    header = Gem::Package::TarHeader.new(name: name, mode: mode,
                                         size: size, prefix: prefix,
                                         mtime: Gem.source_date_epoch).to_s

    @io.write header
    os = BoundedStream.new @io, size

    yield os if block_given?

    min_padding = size - os.written
    @io.write("\0" * min_padding)

    remainder = (512 - (size % 512)) % 512
    @io.write("\0" * remainder)

    self
  end

  ##
  # Adds symlink +name+ with permissions +mode+, linking to +target+.

  def add_symlink(name, target, mode)
    check_closed

    name, prefix = split_name name

    header = Gem::Package::TarHeader.new(name: name, mode: mode,
                                         size: 0, typeflag: "2",
                                         linkname: target,
                                         prefix: prefix,
                                         mtime: Gem.source_date_epoch).to_s

    @io.write header

    self
  end

  ##
  # Raises IOError if the TarWriter is closed

  def check_closed
    raise IOError, "closed #{self.class}" if closed?
  end

  ##
  # Closes the TarWriter

  def close
    check_closed

    @io.write "\0" * 1024
    flush

    @closed = true
  end

  ##
  # Is the TarWriter closed?

  def closed?
    @closed
  end

  ##
  # Flushes the TarWriter's IO

  def flush
    check_closed

    @io.flush if @io.respond_to? :flush
  end

  ##
  # Creates a new directory in the tar file +name+ with +mode+

  def mkdir(name, mode)
    check_closed

    name, prefix = split_name(name)

    header = Gem::Package::TarHeader.new name: name, mode: mode,
                                         typeflag: "5", size: 0,
                                         prefix: prefix,
                                         mtime: Gem.source_date_epoch

    @io.write header

    self
  end

  ##
  # Splits +name+ into a name and prefix that can fit in the TarHeader

  def split_name(name) # :nodoc:
    if name.bytesize > 256
      raise Gem::Package::TooLongFileName.new("File \"#{name}\" has a too long path (should be 256 or less)")
    end

    prefix = ""
    if name.bytesize > 100
      parts = name.split("/", -1) # parts are never empty here
      name = parts.pop            # initially empty for names with a trailing slash ("foo/.../bar/")
      prefix = parts.join("/")    # if empty, then it's impossible to split (parts is empty too)
      while !parts.empty? && (prefix.bytesize > 155 || name.empty?)
        name = parts.pop + "/" + name
        prefix = parts.join("/")
      end

      if name.bytesize > 100 || prefix.empty?
        raise Gem::Package::TooLongFileName.new("File \"#{prefix}/#{name}\" has a too long name (should be 100 or less)")
      end

      if prefix.bytesize > 155
        raise Gem::Package::TooLongFileName.new("File \"#{prefix}/#{name}\" has a too long base path (should be 155 or less)")
      end
    end

    [name, prefix]
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         rubygems/rubygems/package/source.rb                                                                 0000644                 00000000110 15040313421 0013437 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::Package::Source # :nodoc:
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                        rubygems/rubygems/package/file_source.rb                                                            0000644                 00000001142 15040313421 0014444 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The primary source of gems is a file on disk, including all usages
# internal to rubygems.
#
# This is a private class, do not depend on it directly. Instead, pass a path
# object to `Gem::Package.new`.

class Gem::Package::FileSource < Gem::Package::Source # :nodoc: all
  attr_reader :path

  def initialize(path)
    @path = path
  end

  def start
    @start ||= File.read path, 20
  end

  def present?
    File.exist? path
  end

  def with_write_io(&block)
    File.open path, "wb", &block
  end

  def with_read_io(&block)
    File.open path, "rb", &block
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/package/tar_header.rb                                                             0000644                 00000014614 15040313421 0014253 0                                                                                                    ustar 00                                                                                                                                                                                                         