rst

    raise Gem::Security::Exception, "missing root certificate" unless root

    raise Gem::Security::Exception,
          "root certificate #{root.subject} is not self-signed " \
          "(issuer #{root.issuer})" if
      root.issuer != root.subject

    check_cert root, root, time
  end

  ##
  # Ensures the root of +chain+ has a trusted certificate in +trust_dir+ and
  # the digests of the two certificates match according to +digester+

  def check_trust(chain, digester, trust_dir)
    raise Gem::Security::Exception, "missing signing chain" unless chain

    root = chain.first

    raise Gem::Security::Exception, "missing root certificate" unless root

    path = Gem::Security.trust_dir.cert_path root

    unless File.exist? path
      message = "root cert #{root.subject} is not trusted".dup

      message << " (root of signing cert #{chain.last.subject})" if
        chain.length > 1

      raise Gem::Security::Exception, message
    end

    save_cert = OpenSSL::X509::Certificate.new File.read path
    save_dgst = digester.digest save_cert.public_key.to_pem

    pkey_str = root.public_key.to_pem
    cert_dgst = digester.digest pkey_str

    raise Gem::Security::Exception,
          "trusted root certificate #{root.subject} checksum " \
          "does not match signing root certificate checksum" unless
      save_dgst == cert_dgst

    true
  end

  ##
  # Extracts the email or subject from +certificate+

  def subject(certificate) # :nodoc:
    certificate.extensions.each do |extension|
      next unless extension.oid == "subjectAltName"

      return extension.value
    end

    certificate.subject.to_s
  end

  def inspect # :nodoc:
    format("[Policy: %s - data: %p signer: %p chain: %p root: %p " \
     "signed-only: %p trusted-only: %p]", @name, @verify_chain, @verify_data, @verify_root, @verify_signer, @only_signed, @only_trusted)
  end

  ##
  # For +full_name+, verifies the certificate +chain+ is valid, the +digests+
  # match the signatures +signatures+ created by the signer depending on the
  # +policy+ settings.
  #
  # If +key+ is given it is used to validate the signing certificate.

  def verify(chain, key = nil, digests = {}, signatures = {}, full_name = "(unknown)")
    if signatures.empty?
      if @only_signed
        raise Gem::Security::Exception,
          "unsigned gems are not allowed by the #{name} policy"
      elsif digests.empty?
        # lack of signatures is irrelevant if there is nothing to check
        # against
      else
        alert_warning "#{full_name} is not signed"
        return
      end
    end

    opt       = @opt
    digester  = Gem::Security.create_digest
    trust_dir = opt[:trust_dir]
    time      = Time.now

    _, signer_digests = digests.find do |_algorithm, file_digests|
      file_digests.values.first.name == Gem::Security::DIGEST_NAME
    end

    if @verify_data
      raise Gem::Security::Exception, "no digests provided (probable bug)" if
        signer_digests.nil? || signer_digests.empty?
    else
      signer_digests = {}
    end

    signer = chain.last

    check_key signer, key if key

    check_cert signer, nil, time if @verify_signer

    check_chain chain, time if @verify_chain

    check_root chain, time if @verify_root

    if @only_trusted
      check_trust chain, digester, trust_dir
    elsif signatures.empty? && digests.empty?
      # trust is irrelevant if there's no signatures to verify
    else
      alert_warning "#{subject signer} is not trusted for #{full_name}"
    end

    signatures.each do |file, _|
      digest = signer_digests[file]

      raise Gem::Security::Exception, "missing digest for #{file}" unless
        digest
    end

    signer_digests.each do |file, digest|
      signature = signatures[file]

      raise Gem::Security::Exception, "missing signature for #{file}" unless
        signature

      check_data signer.public_key, digester, signature, digest if @verify_data
    end

    true
  end

  ##
  # Extracts the certificate chain from the +spec+ and calls #verify to ensure
  # the signatures and certificate chain is valid according to the policy..

  def verify_signatures(spec, digests, signatures)
    chain = spec.cert_chain.map do |cert_pem|
      OpenSSL::X509::Certificate.new cert_pem
    end

    verify chain, nil, digests, signatures, spec.full_name

    true
  end

  alias_method :to_s, :name # :nodoc:
end
                                                                                                                                                                                                               rubygems/rubygems/security/policies.rb                                                              0000644                 00000006077 15040313417 0014251 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Gem::Security
  ##
  # No security policy: all package signature checks are disabled.

  NoSecurity = Policy.new(
    "No Security",
    verify_data: false,
    verify_signer: false,
    verify_chain: false,
    verify_root: false,
    only_trusted: false,
    only_signed: false
  )

  ##
  # AlmostNo security policy: only verify that the signing certificate is the
  # one that actually signed the data.  Make no attempt to verify the signing
  # certificate chain.
  #
  # This policy is basically useless. better 