ents_entry|
            @contents << contents_entry.full_name
          end
        end

        return @contents
      end
    end
  rescue Zlib::GzipFile::Error, EOFError, Gem::Package::TarInvalidError => e
    raise Gem::Package::FormatError.new e.message, @gem
  end

  ##
  # Creates a digest of the TarEntry +entry+ from the digest algorithm set by
  # the security policy.

  def digest(entry) # :nodoc:
    algorithms = if @checksums
      @checksums.to_h {|algorithm, _| [algorithm, Gem::Security.create_digest(algorithm)] }
    elsif Gem::Security::DIGEST_NAME
      { Gem::Security::DIGEST_NAME => Gem::Security.create_digest(Gem::Security::DIGEST_NAME) }
    end

    return @digests if algorithms.nil? || algorithms.empty?

    buf = String.new(capacity: 16_384, encoding: Encoding::BINARY)
    until entry.eof?
      entry.readpartial(16_384, buf)
      algorithms.each_value {|digester| digester << buf }
    end
    entry.rewind

    algorithms.each do |algorithm, digester|
      @digests[algorithm][entry.full_name] = digester
    end

    @digests
  end

  ##
  # Extracts the files in this package into +destination_dir+
  #
  # If +pattern+ is specified, only entries matching that glob will be
  # extracted.

  def extract_files(destination_dir, pattern = "*")
    verify unless @spec

    FileUtils.mkdir_p destination_dir, mode: dir_mode && 0o755

    @gem.with_read_io do |io|
      reader = Gem::Package::TarReader.new io

      reader.each do |entry|
        next unless entry.full_name == "data.tar.gz"

        extract_tar_gz entry, destination_dir, pattern

        break # ignore further entries
      end
    end
  rescue Zlib::GzipFile::Error, EOFError, Gem::Package::TarInvalidError => e
    raise Gem::Package::FormatError.new e.message, @gem
  end

  ##
  # Extracts all the files in the gzipped tar archive +io+ into
  # +destination_dir+.
  #
  # If an entry in the archive contains a relative path above
  # +destination_dir+ or an absolute path is encountered an exception is
  # raised.
  #
  # If +pattern+ is specified, only entries matching that glob will be
  # extracted.

  def extract_tar_gz(io, destination_dir, pattern = "*") # :nodoc:
    destination_dir = File.realpath(destination_dir)

    directories = []
    symlinks = []

    open_tar_gz io do |tar|
      tar.each do |entry|
        full_name = entry.full_name
        next unless File.fnmatch pattern, full_name, File::FNM_DOTMATCH

        destination = install_location full_name, destination_dir

        if entry.symlink?
          link_target = entry.header.linkname
          real_destination = link_target.start_with?("/") ? link_target : File.expand_path(link_target, File.dirname(destination))

          raise Gem::Package::SymlinkError.new(full_name, real_destination, destination_dir) unless
            normalize_path(real_destination).start_with? normalize_path(destination_dir + "/")

          symlinks << [full_name, link_target, destination, real_destination]
        end

        FileUtils.rm_rf destination

        mkdir =
          if entry.directory?
            destination
          else
            File.dirname destination
          end

        unless directories.include?(mkdir)
          FileUtils.mkdir_p mkdir, mode: dir_mode ? 0o755 : (entry.header.mode if entry.directory?)
          directories << mkdir
        end

        if entry.file?
          File.open(destination, "wb") {|out| copy_stream(entry, out) }
          FileUtils.chmod file_mode(entry.header.mode) & ~File.umask, destination
        end

        verbose destination
      end
    end

    symlinks.each do |name, target, destination, real_destination|
      if File.exist?(real_destination)
        File.symlink(target, destination)
      else
        alert_warning "#{@spec.full_name} ships with a dangling symlink named #{name} pointing to missing #{target} file. Ignoring"
      end
    end

    if dir_mode
      File.chmod(dir_mode, *directories)
    end
  end

  def file_mode(mode) # :nodoc:
    ((mode & 0o111).zero? ? data_mode : prog_mode) ||
      # If we're not using one of the default modes, then we're going to fall
      # back to the mode from the tarball. In this case we need to mask it down
      # to fit into 2^16 bits (the maximum value for a mode in CRuby since it
      # gets put into an unsigned short).
      (mode & ((1 << 16) - 1))
  end

  ##
  # Gzips content written to +gz_io+ to +io+.
  #--
  # Also sets the gzip modification time to the package build time to ease
  # testing.

  def gzip_to(io) # :yields: gz_io
    gz_io = Zlib::GzipWriter.new io, Zlib::BEST_COMPRESSION
    gz_io.mtime = @build_time

    yield gz_io
  ensure
    gz_io.close
  end

  ##
  # Returns the full path for installing +filename+.
  #
  # If +filename+ is not inside +destination_dir+ an exception is raised.

  def install_location(filename, destination_dir) # :nodoc:
    raise Gem::Package::PathError.new(filename, destination_dir) if
      filename.start_with? "/"

    de