on, or either one has no version
  #
  # Additionally, the platform will match if the local CPU is 'arm' and the
  # other CPU starts with "armv" (for generic 32-bit ARM family support).
  #
  # Of note, this method is not commutative. Indeed the OS 'linux' has a
  # special case: the version is the libc name, yet while "no version" stands
  # as a wildcard for a binary gem platform (as for other OSes), for the
  # runtime platform "no version" stands for 'gnu'. To be able to distinguish
  # these, the method receiver is the gem platform, while the argument is
  # the runtime platform.
  #
  #--
  # NOTE: Until it can be removed, changes to this method must also be reflected in `bundler/lib/bundler/rubygems_ext.rb`

  def ===(other)
    return nil unless Gem::Platform === other

    # universal-mingw32 matches x64-mingw-ucrt
    return true if (@cpu == "universal" || other.cpu == "universal") &&
                   @os.start_with?("mingw") && other.os.start_with?("mingw")

    # cpu
    ([nil,"universal"].include?(@cpu) || [nil, "universal"].include?(other.cpu) || @cpu == other.cpu ||
    (@cpu == "arm" && other.cpu.start_with?("armv"))) &&

      # os
      @os == other.os &&

      # version
      (
        (@os != "linux" && (@version.nil? || other.version.nil?)) ||
        (@os == "linux" && (normalized_linux_version == other.normalized_linux_version || ["musl#{@version}", "musleabi#{@version}", "musleabihf#{@version}"].include?(other.version))) ||
        @version == other.version
      )
  end

  #--
  # NOTE: Until it can be removed, changes to this method must also be reflected in `bundler/lib/bundler/rubygems_ext.rb`

  def normalized_linux_version
    return nil unless @version

    without_gnu_nor_abi_modifiers = @version.sub(/\Agnu/, "").sub(/eabi(hf)?\Z/, "")
    return nil if without_gnu_nor_abi_modifiers.empty?

    without_gnu_nor_abi_modifiers
  end

  ##
  # Does +other+ match this platform?  If +other+ is a String it will be
  # converted to a Gem::Platform first.  See #=== for matching rules.

  def =~(other)
    case other
    when Gem::Platform then # nop
    when String then
      # This data is from http://gems.rubyforge.org/gems/yaml on 19 Aug 2007
      other = case other
              when /^i686-darwin(\d)/     then ["x86",       "darwin",  $1]
              when /^i\d86-linux/         then ["x86",       "linux",   nil]
              when "java", "jruby"        then [nil,         "java",    nil]
              when /^dalvik(\d+)?$/       then [nil,         "dalvik",  $1]
              when /dotnet(\-(\d+\.\d+))?/ then ["universal","dotnet",  $2]
              when /mswin32(\_(\d+))?/    then ["x86",       "mswin32", $2]
              when /mswin64(\_(\d+))?/    then ["x64",       "mswin64", $2]
              when "powerpc-darwin"       then ["powerpc",   "darwin",  nil]
              when /powerpc-darwin(\d)/   then ["powerpc",   "darwin",  $1]
              when /sparc-solaris2.8/     then ["sparc",     "solaris", "2.8"]
              when /universal-darwin(\d)/ then ["universal", "darwin",  $1]
              else other
      end

      other = Gem::Platform.new other
    else
      return nil
    end

    self === other
  end

  ##
  # A pure-Ruby gem that may use Gem::Specification#extensions to build
  # binary files.

  RUBY = "ruby"

  ##
  # A platform-specific gem that is built for the packaging Ruby's platform.
  # This will be replaced with Gem::Platform::local.

  CURRENT = "current"
end
                                                                                                rubygems/rubygems/query_utils.rb                                                                    0000644                 00000020777 15040313416 0013162 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "local_remote_options"
require_relative "spec_fetcher"
require_relative "version_option"
require_relative "text"

module Gem::QueryUtils
  include Gem::Text
  include Gem::LocalRemoteOptions
  include Gem::VersionOption

  def add_query_options
    add_option("-i", "--[no-]installed",
               "Check for installed gem") do |value, options|
      options[:installed] = value
    end

    add_option("-I", "Equivalent to --no-installed") do |_value, options|
      options[:installed]