rubygems/rubygems/ext/rake_builder.rb                                                               0000644                 00000002066 15040313420 0014007 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../shellwords"

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

class Gem::Ext::RakeBuilder < Gem::Ext::Builder
  def self.build(extension, dest_path, results, args=[], lib_dir=nil, extension_dir=Dir.pwd,
    target_rbconfig=Gem.target_rbconfig)
    if target_rbconfig.path
      warn "--target-rbconfig is not yet supported for Rake extensions. Ignoring"
    end

    if /mkrf_conf/i.match?(File.basename(extension))
      run([Gem.ruby, File.basename(extension), *args], results, class_name, extension_dir)
    end

    rake = ENV["rake"]

    if rake
      rake = Shellwords.split(rake)
    else
      begin
        rake = ruby << "-rrubygems" << Gem.bin_path("rake", "rake")
      rescue Gem::Exception
        rake = [Gem.default_exec_format % "rake"]
      end
    end

    rake_args = ["RUBYARCHDIR=#{dest_path}", "RUBYLIBDIR=#{dest_path}", *args]
    run(rake + rake_args, results, class_name, extension_dir)

    results
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          rubygems/rubygems/ext/cargo_builder/link_flag_converter.rb                                          0000644                 00000001354 15040313420 0020174 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::Ext::CargoBuilder < Gem::Ext::Builder
  # Converts Ruby link flags into something cargo understands
  class LinkFlagConverter
    FILTERED_PATTERNS = [
      /compress-debug-sections/, # Not supported by all linkers, and not required for Rust
    ].freeze

    def self.convert(arg)
      return [] if FILTERED_PATTERNS.any? {|p| p.match?(arg) }

      case arg.chomp
      when /^-L\s*(.+)$/
        ["-L", "native=#{$1}"]
      when /^--library=(\w+\S+)$/, /^-l\s*(\w+\S+)$/
 