# frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "../user_interaction"
require_relative "../shellwords"

class Gem::Ext::Builder
  include Gem::UserInteraction

  attr_accessor :build_args # :nodoc:

  def self.class_name
    name =~ /Ext::(.*)Builder/
    $1.downcase
  end

  def self.make(dest_path, results, make_dir = Dir.pwd, sitedir = nil, targets = ["clean", "", "install"],
    target_rbconfig: Gem.target_rbconfig)
    unless File.exist? File.join(make_dir, "Makefile")
      raise Gem::InstallError, "Makefile not found"
    end

    # try to find make program from Ruby configure arguments first
    target_rbconfig["configure_args"] =~ /with-make-prog\=(\w+)/
    make_program_name = ENV["MAKE"] || ENV["make"] || $1
    make_program_name ||= RUBY_PLATFORM.include?("mswin") ? "nmake" : "make"
    make_program = Shellwords.split(make_program_name)

    # The installation of the bundled gems is failed when DESTDIR is empty in mswin platform.
    destdir = /\bnmake/i !~ make_program_name || ENV["DESTDIR"] && ENV["DESTDIR"] != "" ? format("DESTDIR=%s", ENV["DESTDIR"]) : ""

    env = [destdir]

    if sitedir
      env << format("sitearchdir=%s", sitedir)
      env << format("sitelibdir=%s", sitedir)
    end

    targets.each do |target|
      # Pass DESTDIR via command line to override what's in MAKEFLAGS
      cmd = [
        *make_program,
        *env,
        target,
      ].reject(&:empty?)
      begin
        run(cmd, results, "make #{target}".rstrip, make_dir)
      rescue Gem::InstallError
        raise unless target == "clean" # ignore clean failure
      end
    end
  end

  def self.ruby
    # Gem.ruby is quoted if it contains whitespace
    cmd = Shellwords.split(Gem.ruby)

    # This load_path is only needed when running rubygems test without a proper installation.
    # Prepending it in a normal installation will cause problem with order of $LOAD_PATH.
    # Therefore only add load_path if it is not present in the default $LOAD_PATH.
    load_path = File.expand_path("../..", __dir__)
    case load_path
    when RbConfig::CONFIG["sitelibdir"], RbConfig::CONFIG["vendorlibdir"], RbConfig::CONFIG["rubylibdir"]
      cmd
    else
      cmd << "-I#{load_path}"
    end
  end

  def self.run(command, results, command_name = nil, dir = Dir.pwd, env = {})
    verbose = Gem.configuration.really_verbose

    begin
      rubygems_gemdeps = ENV["RUBYGEMS_GEMDEPS"]
