ew(uri)
  end

  ##
  # Downloads +uri+ to +path+ if necessary. If no path is given, it just
  # passes the data.

  def cache_update_path(uri, path = nil, update = true)
    mtime = begin
              path && File.stat(path).mtime
            rescue StandardError
              nil
            end

    data = fetch_path(uri, mtime)

    if data.nil? # indicates the server returned 304 Not Modified
      return Gem.read_binary(path)
    end

    if update && path
      Gem.write_binary(path, data)
    end

    data
  end

  ##
  # Performs a Gem::Net::HTTP request of type +request_class+ on +uri+ returning
  # a Gem::Net::HTTP response object.  request maintains a table of persistent
  # connections to reduce connect overhead.

  def request(uri, request_class, last_modified = nil)
    proxy = proxy_for @proxy, uri
    pool  = pools_for(proxy).pool_for uri

    request = Gem::Request.new uri, request_class, last_modified, pool

    request.fetch do |req|
      yield req if block_given?
    end
  end

  def https?(uri)
    uri.scheme.casecmp("https").zero?
  end

  def close_all
    @pools.each_value(&:close_all)
  end

  private

  def proxy_for(proxy, uri)
    Gem::Request.proxy_uri(proxy || Gem::Request.get_proxy_from_env(uri.scheme))
  end

  def pools_for(proxy)
    @pool_lock.synchronize do
      @pools[proxy] ||= Gem::Request::ConnectionPools.new proxy, @cert_files
    end
  end
end
                                                                                                                            rubygems/rubygems/requirement.rb                                                                    0000644                 00000016202 15040313422 0013116 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "version"

##
# A Requirement is a set of one or more version restrictions. It supports a
# few (<tt>=, !=, >, <, >=, <=, ~></tt>) different restriction operators.
#
# See Gem::Version for a description on how versions and requirements work
# together in RubyGems.

class Gem::Requirement
  OPS = { # :nodoc:
    "=" => lambda {|v, r| v == r },
    "!=" => lambda {|v, r| v != r },
    ">" => lambda {|v, r| v > r },
    "<" => lambda {|v, r| v < r },
    ">=" => lambda {|v, r| v >= r },
    "<=" => lambda {|v, r| v <= r },
    "~>" => lambda {|v, r| v >= r && v.release < r.bump },
  }.freeze

  SOURCE_SET_REQUIREMENT = Struct.new(:for_lockfile).new "!" # :nodoc:

  quoted = Regexp.union(OPS.keys)
  PATTERN_RAW = "\\s*(#{quoted})?\\s*(#{Gem::Version::VERSION_PATTERN})\\s*".freeze # :nodoc:

  ##
  # A regular expression that matches a requirement

  PATTERN = /\A#{PATTERN_RAW}\z/

  ##
  # The default requirement matches any non-prerelease version

  DefaultRequirement = [">=", Gem::Version.new(0)].freeze

  ##
  # The default requirement matches any version

  DefaultPrereleaseRequirement = [">=", Gem::Version.new("0.a")].freeze

  ##
  # Raised when a bad requirement is encountered

  class BadRequirementError < ArgumentError; end

  ##
  # Factory method to create a Gem::Requirement object.  Input may be
  # a Version, a String, or nil.  Intended to simplify client code.
  #
  # If the input is "weird", the default version requirement is
  # returned.

  def self.create(*inputs)
    return new inputs if inputs.length > 1

    input = inputs.shift

    case input
    when Gem::Requirement then
      input
    when Gem::Version, Array then
      new input
    when "!" then
      source_set
    else
      if input.respond_to? :to_str
        new [input.to_str]
      else
        default
      end
    end
  end

  def self.default
    new ">= 0"
  end

  def self.default_prerelease
    new ">= 0.a"
  end

  ###
  # A source set requirement, used for Gemfiles and lockfiles

  def self.source_set # :nodoc:
    SOURCE_SET_REQUIREMENT
  end

  ##
  # Parse +obj+, returning an <tt>[op, version]</tt> pair. +obj+ can
  # be a String or a Gem::Version.
  #
  # If +obj+ is a String, it can be either a full requirement
  # specification, like <tt>">= 1.2"</tt>, or a simple version number,
  # like <tt>"1.2"</tt>.
  #
  #     parse("> 1.0")                 # => [">", Gem::Version.new("1.0")]
  #     parse("1.0")                   # => ["=", Gem::Version.new("1.0")]
  #     parse(Gem::Version.new("1.0")) # => ["=,  Gem::Version.new("1.0")]

  def self.parse(obj)
    return ["=", obj] if Gem::Version === obj

    unless PATTERN =~ obj.to_s
      raise BadRequirementError, "Illformed requirement [#{obj.inspect}]"
    end
    op = -($1 || "=")
    version = -$2

    if op == ">=" && version == "0"
      DefaultRequirement
    elsif op == ">=" && version == "0.a"
      DefaultPrereleaseRequirement
    else
      [op, Gem::Version.new(version)]
    end
  end

  ##
  # An array of requirement pairs. The first element of the pair is
  # the op, and the second is the Gem::Version.

  attr_reader :requirements # :nodoc:

  ##
  # Constructs a requirement from +requirements+. Requirements can be
  # Strings, Gem::Versions, or Arrays of those. +nil+ and duplicate
  # requirements are ignored. An empty set of +requirements+ is the
  # same as <tt>">= 0"</tt>.

  def initialize(*requirements)
    requirements = requirements.flatten
    requirements.compact!
    requirements.uniq!

    if requirements.empty?
      @requirements = [DefaultRequirement]
    else
      @requirements = requirements.map! {|r| self.class.parse r }
    end
  end

  ##
  # Concatenates the +new+ requirements onto this requirement.

  def concat(new)
    new = new.flatten
    new.compact!
    new.uniq!
    new = new.map {|r| self.class.parse r }

    @requirements.concat new
  end

  ##
  # Formats this requirement for use in a Gem::RequestSet::Lockfile.

  def for_lockfile # :nodoc:
    return if @requirements == [DefaultRequirement]

    list = requirements.sort_by do |_, version|
      version
    end.map do |op, version|
      "#{op} #{version}"
    end.uniq

    " (#{list.join ", "})"
  end

  ##
  # true if this gem has no requirements.

  def none?
    if @requirements.size == 1
      @requirements[0] == DefaultRequirement
    else
      false
    end
  end

  ##
  # true if the requirement is for only an exact version

  def exact?
    return false unless @requirements.size == 1
    @requirements[0][0] == "="
  end

  def as_list # :nodoc:
    requirements.map {|op, version| "#{op} #{version}" }
  end

  def hash # :nodoc:
    requirements.map {|r| r.first == "~>" ? [r[0], r[1].to_s] : r }.sort.hash
  end

  def marshal_dump # :nodoc:
    [@requirements]
  end

  def marshal_load(array) # :nodoc:
    @requirements = array[0]

    raise TypeError, "wrong @requirements" unless Array === @requirements &&
                                                  @requirements.all? {|r| r.size == 2 && (r.first.is_a?(String) || r[0] = "=") && r.last.is_a?(Gem::Version) }
  end

  def yaml_initialize(tag, vals) # :nodoc:
    vals.each do |ivar, val|
      instance_variable_set "@#{ivar}", val
    end
  end

  def init_with(coder) # :nodoc:
    yaml_initialize coder.tag, coder.map
  end

  def encode_with(coder) # :nodoc:
    coder.add "requirements", @requirements
  end

  ##
  # A requirement is a prerelease if any of the versions inside of it
  # are prereleases

  def prerelease?
    requirements.any? {|r| r.last.prerelease? }
  end

  def pretty_print(q) # :nodoc:
    q.group 1, "Gem::Requirement.new(", ")" do
      q.pp as_list
    end
  end

  ##
  # True if +version+ satisfies this Requirement.

  def satisfied_by?(version)
    raise ArgumentError, "Need a Gem::Version: #{version.inspect}" unless
      Gem::Version === version
    requirements.all? {|op, rv| OPS.fetch(op).call version, rv }
  end

  alias_method :===, :satisfied_by?
  alias_method :=~, :satisfied_by?

  ##
  # True if the requirement will not always match the latest version.

  def specific?
    return true if @requirements.length > 1 # GIGO, > 1, > 2 is silly

    !%w[> >=].include? @requirements.first.first # grab the operator
  end

  def to_s # :nodoc:
    as_list.join ", "
  end

  def ==(other) # :nodoc:
    return unless Gem::Requirement === other

    # An == check is always necessary
    return false unless _sorted_requirements == other._sorted_requirements

    # An == check is sufficient unless any requirements use ~>
    return true unless _tilde_requirements.any?

    # If any requirements use ~> we use the stricter `#eql?` that also checks
    # that version precision is the same
    _tilde_requirements.eql?(other._tilde_requirements)
  end

  protected

  def _sorted_requirements
    @_sorted_requirements ||= requirements.sort_by(&:to_s)
  end

  def _tilde_requirements
    @_tilde_requirements ||= _sorted_requirements.select {|r| r.first == "~>" }
  end

  def initialize_copy(other) # :nodoc:
    @requirements = other.requirements.dup
    super
  end
end

class Gem::Version
  # This is needed for compatibility with older yaml
  # gemspecs.

  Requirement = Gem::Requirement # :nodoc:
end
                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/rdoc.rb                                                                           0000644                 00000001224 15040313422 0011503 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../rubygems"

begin
  require "rdoc/rubygems_hook"
  module Gem
    ##
    # Returns whether RDoc defines its own install hooks through a RubyGems
    # plugin. This and whatever is guarded by it can be removed once no
    # supported Ruby ships with RDoc older than 6.9.0.

    def self.rdoc_hooks_defined_via_plugin?
      Gem::Version.new(::RDoc::VERSION) >= Gem::Version.new("6.9.0")
    end

    if rdoc_hooks_defined_via_plugin?
      RDoc = ::RDoc::RubyGemsHook
    else
      RDoc = ::RDoc::RubygemsHook

      Gem.done_installing(&Gem::RDoc.method(:generation_hook))
    end
  end
rescue LoadError
end
                                                                                                                                                                                                                                                                                                                                                                            rubygems/rubygems/available_set.rb                                                                  0000644                 00000006003 15040313422 0013347 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::AvailableSet
  include Enumerable

  Tuple = Struct.new(:spec, :source)

  attr_accessor :remote # :nodoc:

  def initialize
    @set = []
    @sorted = nil
    @remote = true
  end

  attr_reader :set

  def add(spec, source)
    @set << Tuple.new(spec, source)
    @sorted = nil
    self
  end

  def <<(o)
    case o
    when Gem::AvailableSet
      s = o.set
    when Array
      s = o.map do |sp,so|
        if !sp.is_a?(Gem::Specification) || !so.is_a?(Gem::Source)
          raise TypeError, "Array must be in [[spec, source], ...] form"
        end

        Tuple.new(sp,so)
      end
    else
      raise TypeError, "must be a Gem::AvailableSet"
    end

    @set += s
    @sorted = nil

    self
  end

  ##
  # Yields each Tuple in this AvailableSet

  def each
    return enum_for __method__ unless block_given?

    @set.each do |tuple|
      yield tuple
    end
  end

  ##
  # Yields the Gem::Specification for each Tuple in this AvailableSet

  def each_spec
    return enum_for __method__ unless block_given?

    each do |tuple|
      yield tuple.spec
    end
  end

  def empty?
    @set.empty?
  end

  def all_specs
    @set.map(&:spec)
  end

  def match_platform!
    @set.reject! {|t| !Gem::Platform.match_spec?(t.spec) }
    @sorted = nil
    self
  end

  def sorted
    @sorted ||= @set.sort do |a,b|
      i = b.spec <=> a.spec
      i != 0 ? i : (a.source <=> b.source)
    end
  end

  def size
    @set.size
  end

  def source_for(spec)
    f = @set.find {|t| t.spec == spec }
    f.source
  end

  ##
  # Converts this AvailableSet into a RequestSet that can be used to install
  # gems.
  #
  # If +development+ is :none then no development dependencies are installed.
  # Other options are :shallow for only direct development dependencies of the
  # gems in this set or :all for all development dependencies.

  def to_request_set(development = :none)
    request_set = Gem::RequestSet.new
    request_set.development = development == :all

    each_spec do |spec|
      request_set.always_install << spec

      request_set.gem spec.name, spec.version
      request_set.import spec.development_dependencies if
        development == :shallow
    end

    request_set
  end

  ##
  #
  # Used by the Resolver, the protocol to use a AvailableSet as a
  # search Set.

  def find_all(req)
    dep = req.dependency

    match = @set.find_all do |t|
      dep.match? t.spec
    end

    match.map do |t|
      Gem::Resolver::LocalSpecification.new(self, t.spec, t.source)
    end
  end

  def prefetch(reqs)
  end

  def pick_best!
    return self if empty?

    @set = [sorted.first]
    @sorted = nil
    self
  end

  def remove_installed!(dep)
    @set.reject! do |_t|
      # already locally installed
      Gem::Specification.any? do |installed_spec|
        dep.name == installed_spec.name &&
          dep.requirement.satisfied_by?(installed_spec.version)
      end
    end

    @sorted = nil
    self
  end

  def inject_into_list(dep_list)
    @set.each {|t| dep_list.add t.spec }
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             rubygems/rubygems/optparse.rb                                                                       0000644                 00000000110 15040313422 0012402 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       dler is under the following license.

  >>>
    Portions copyright (c) 2                                                                                                                                                                                                                                                                                                                                                                                                                                                        rubygems/rubygems/installer_uninstaller_utils.rb                                                    0000644                 00000001403 15040313422 0016410 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Helper methods for both Gem::Installer and Gem::Uninstaller

module Gem::InstallerUninstallerUtils
  def regenerate_plugins_for(spec, plugins_dir)
    plugins = spec.plugins
    return if plugins.empty?

    require "pathname"

    spec.plugins.each do |plugin|
      plugin_script_path = File.join plugins_dir, "#{spec.name}_plugin#{File.extname(plugin)}"

      File.open plugin_script_path, "wb" do |file|
        file.puts "require_relative '#{Pathname.new(plugin).relative_path_from(Pathname.new(plugins_dir))}'"
      end

      verbose plugin_script_path
    end
  end

  def remove_plugins_for(spec, plugins_dir)
    FileUtils.rm_f Gem::Util.glob_files_in_dir("#{spec.name}#{Gem.plugin_suffix_pattern}", plugins_dir)
  end
end
                                                                                                                                                                                                                                                             rubygems/rubygems/exceptions.rb                                                                     0000644                 00000016202 15040313422 0012737 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "deprecate"
require_relative "unknown_command_spell_checker"

##
# Base exception class for RubyGems.  All exception raised by RubyGems are a
# subclass of this one.
class Gem::Exception < RuntimeError; end

class Gem::CommandLineError < Gem::Exception; end

class Gem::UnknownCommandError < Gem::Exception
  attr_reader :unknown_command

  def initialize(unknown_command)
    self.class.attach_correctable

    @unknown_command = unknown_command
    super("Unknown command #{unknown_command}")
  end

  def self.attach_correctable
    return if defined?(@attached)

    if defined?(DidYouMean::SPELL_CHECKERS) && defined?(DidYouMean::Correctable)
      if DidYouMean.respond_to?(:correct_error)
        DidYouMean.correct_error(Gem::UnknownCommandError, Gem::UnknownCommandSpellChecker)
      else
        DidYouMean::SPELL_CHECKERS["Gem::UnknownCommandError"] =
          Gem::UnknownCommandSpellChecker

        prepend DidYouMean::Correctable
      end
    end

    @attached = true
  end
end

class Gem::DependencyError < Gem::Exception; end

class Gem::DependencyRemovalException < Gem::Exception; end

##
# Raised by Gem::Resolver when a Gem::Dependency::Conflict reaches the
# toplevel.  Indicates which dependencies were incompatible through #conflict
# and #conflicting_dependencies

class Gem::DependencyResolutionError < Gem::DependencyError
  attr_reader :conflict

  def initialize(conflict)
    @conflict = conflict
    a, b = conflicting_dependencies

    super "conflicting dependencies #{a} and #{b}\n#{@conflict.explanation}"
  end

  def conflicting_dependencies
    @conflict.conflicting_dependencies
  end
end

##
# Raised when attempting to uninstall a gem that isn't in GEM_HOME.

class Gem::GemNotInHomeException < Gem::Exception
  attr_accessor :spec
end

###
# Raised when removing a gem with the uninstall command fails

class Gem::UninstallError < Gem::Exception
  attr_accessor :spec
end

class Gem::DocumentError < Gem::Exception; end

##
# Potentially raised when a specification is validated.
class Gem::EndOfYAMLException < Gem::Exception; end

##
# Signals that a file permission error is preventing the user from
# operating on the given directory.

class Gem::FilePermissionError < Gem::Exception
  attr_reader :directory

  def initialize(directory)
    @directory = directory

    super "You don't have write permissions for the #{directory} directory."
  end
end

##
# Used to raise parsing and loading errors
class Gem::FormatException < Gem::Exception
  attr_accessor :file_path
end

class Gem::GemNotFoundException < Gem::Exception; end

class Gem::SpecificGemNotFoundException < Gem::GemNotFoundException
  ##
  # Creates a new SpecificGemNotFoundException for a gem with the given +name+
  # and +version+.  Any +errors+ encountered when attempting to find the gem
  # are also stored.

  def initialize(name, version, errors=nil)
    super "Could not find a valid gem '#{name}' (#{version}) locally or in a repository"

    @name = name
    @version = version
    @errors = errors
  end

  ##
  # The name of the gem that could not be found.

  attr_reader :name

  ##
  # The version of the gem that could not be found.

  attr_reader :version

  ##
  # Errors encountered attempting to find the gem.

  attr_reader :errors
end

Gem.deprecate_constant :SpecificGemNotFoundException

##
# Raised by Gem::Resolver when dependencies conflict and create the
# inability to find a valid possible spec for a request.

class Gem::ImpossibleDependenciesError < Gem::Exception
  attr_reader :conflicts
  attr_reader :request

  def initialize(request, conflicts)
    @request   = request
    @conflicts = conflicts

    super build_message
  end

  def build_message # :nodoc:
    requester  = @request.requester
    requester  = requester ? requester.spec.full_name : "The user"
    dependency = @request.dependency

    message = "#{requester} requires #{dependency} but it conflicted:\n".dup

    @conflicts.each do |_, conflict|
      message << conflict.explanation
    end

    message
  end

  def dependency
    @request.dependency
  end
end

class Gem::InstallError < Gem::Exception; end

class Gem::RuntimeRequirementNotMetError < Gem::InstallError
  attr_accessor :suggestion
  def message
    [suggestion, super].compact.join("\n\t")
  end
end

##
# Potentially raised when a specification is validated.
class Gem::InvalidSpecificationException < Gem::Exception; end

class Gem::OperationNotSupportedError < Gem::Exception; end

##
# Signals that a remote operation cannot be conducted, probably due to not
# being connected (or just not finding host).
#--
# TODO: create a method that tests connection to the preferred gems server.
# All code dealing with remote operations will want this.  Failure in that
# method should raise this error.
class Gem::RemoteError < Gem::Exception; end

class Gem::RemoteInstallationCancelled < Gem::Exception; end

class Gem::RemoteInstallationSkipped < Gem::Exception; end

##
# Represents an error communicating via HTTP.
class Gem::RemoteSourceException < Gem::Exception; end

##
# Raised when a gem dependencies file specifies a ruby version that does not
# match the current version.

class Gem::RubyVersionMismatch < Gem::Exception; end

##
# Raised by Gem::Validator when something is not right in a gem.

class Gem::VerificationError < Gem::Exception; end

##
# Raised by Gem::WebauthnListener when an error occurs during security
# device verification.

class Gem::WebauthnVerificationError < Gem::Exception
  def initialize(message)
    super "Security device verification failed: #{message}"
  end
end

##
# Raised to indicate that a system exit should occur with the specified
# exit_code

class Gem::SystemExitException < SystemExit
  ##
  # The exit code for the process

  alias_method :exit_code, :status

  ##
  # Creates a new SystemExitException with the given +exit_code+

  def initialize(exit_code)
    super exit_code, "Exiting RubyGems with exit_code #{exit_code}"
  end
end

##
# Raised by Resolver when a dependency requests a gem for which
# there is no spec.

class Gem::UnsatisfiableDependencyError < Gem::DependencyError
  ##
  # The unsatisfiable dependency.  This is a
  # Gem::Resolver::DependencyRequest, not a Gem::Dependency

  attr_reader :dependency

  ##
  # Errors encountered which may have contributed to this exception

  attr_accessor :errors

  ##
  # Creates a new UnsatisfiableDependencyError for the unsatisfiable
  # Gem::Resolver::DependencyRequest +dep+

  def initialize(dep, platform_mismatch=nil)
    if platform_mismatch && !platform_mismatch.empty?
      plats = platform_mismatch.map {|x| x.platform.to_s }.sort.uniq
      super "Unable to resolve dependency: No match for '#{dep}' on this platform. Found: #{plats.join(", ")}"
    else
      if dep.explicit?
        super "Unable to resolve dependency: user requested '#{dep}'"
      else
        super "Unable to resolve dependency: '#{dep.request_context}' requires '#{dep}'"
      end
    end

    @dependency = dep
    @errors     = []
  end

  ##
  # The name of the unresolved dependency

  def name
    @dependency.name
  end

  ##
  # The Requirement of the unresolved dependency (not Version).

  def version
    @dependency.requirement
  end
end
                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/installer.rb                                                                      0000644                 00000067363 15040313422 0012571 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "installer_uninstaller_utils"
require_relative "exceptions"
require_relative "deprecate"
require_relative "package"
require_relative "ext"
require_relative "user_interaction"

##
# The installer installs the files contained in the .gem into the Gem.home.
#
# Gem::Installer does the work of putting files in all the right places on the
# filesystem including unpacking the gem into its gem dir, installing the
# gemspec in the specifications dir, storing the cached gem in the cache dir,
# and installing either wrappers or symlinks for executables.
#
# The installer invokes pre and post install hooks.  Hooks can be added either
# through a rubygems_plugin.rb file in an installed gem or via a
# rubygems/defaults/#{RUBY_ENGINE}.rb or rubygems/defaults/operating_system.rb
# file.  See Gem.pre_install and Gem.post_install for details.

class Gem::Installer
  extend Gem::Deprecate

  ##
  # Paths where env(1) might live.  Some systems are broken and have it in
  # /bin

  ENV_PATHS = %w[/usr/bin/env /bin/env].freeze

  ##
  # Deprecated in favor of Gem::Ext::BuildError
