nment.
  #
  def initialize(env)
    @home = normalize_home_dir(env["GEM_HOME"] || Gem.default_dir)
    @path = split_gem_path env["GEM_PATH"], @home

    @spec_cache_dir = env["GEM_SPEC_CACHE"] || Gem.default_spec_cache_dir
  end

  private

  def normalize_home_dir(home)
    if File::ALT_SEPARATOR
      home = home.gsub(File::ALT_SEPARATOR, File::SEPARATOR)
    end

    expand(home)
  end

  ##
  # Split the Gem search path (as reported by Gem.path).

  def split_gem_path(gpaths, home)
    # FIX: it should be [home, *path], not [*path, home]

    gem_path = []

    if gpaths
      gem_path = gpaths.split(Gem.path_separator)
      # Handle the path_separator being set to a regexp, which will cause
      # end_with? to error
      if /#{Gem.path_separator}\z/.match?(gpaths)
        gem_path += default_path
      end

      if File::ALT_SEPARATOR
        gem_path.map! do |this_path|
          this_path.gsub File::ALT_SEPARATOR, File::SEPARATOR
        end
      end

      gem_path << home
    else
      gem_path = default_path
    end

    gem_path.map {|path| expand(path) }.uniq
  end

  # Return the default Gem path
  def default_path
    Gem.default_path + [@home]
  end

  def expand(path)
    if File.directory?(path)
      File.realpath(path)
    else
      path
    end
  end
end
                                                                                                                                                                                                                                        rubygems/rubygems/request.rb                                                                        0000644                 00000021316 15040313416 0012253 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal