   rescue ArgumentError => e
        # Specialize only exceptions from Gem::Package::TarHeader.strict_oct
        raise e unless e.message.match?(/ is not an octal string$/)
        raise Gem::Package::TarInvalidError, e.message
      end

      return if header.empty?
      entry = Gem::Package::TarReader::Entry.new header, @io
      yield entry
      entry.close
    end
  end

  alias_method :each_entry, :each

  ##
  # NOTE: Do not call #rewind during #each

  def rewind
    if @init_pos == 0
      @io.rewind
    else
      @io.pos = @init_pos
    end
  end

  ##
  # Seeks through the tar file until it finds the +entry+ with +name+ and
  # yields it.  Rewinds the tar file to the beginning when the block
  # terminates.

  def seek(name) # :yields: entry
    found = find do |entry|
      entry.full_na