ok?(spec) # :nodoc:
    return true if @force_ignore

    deplist = Gem::DependencyList.from_specs
    deplist.ok_to_remove?(spec.full_name, @check_dev)
  end

  ##
  # Should the uninstallation abort if a dependency will go unsatisfied?
  #
  # See ::new.

  def abort_on_dependent? # :nodoc:
    @abort_on_dependent
  end

  ##
  # Asks if it is OK to remove +spec+.  Returns true if it is OK.

  def ask_if_ok(spec) # :nodoc:
    msg = [""]
    msg << "You have requested to uninstall the gem:"
    msg << "\t#{spec.full_name}"
    msg << ""

    siblings = Gem::Specification.select do |s|
      s.name == spec.name && s.full_name != spec.full_name
    end

    spec.dependent_gems(@check_dev).each do |dep_spec, dep, _satlist|
      unless siblings.any? {|s| s.satisfies_requirement? dep }
        msg << "#{dep_spec.name}-#{dep_spec.version} depends on #{dep}"
      end
    end

    msg << "If you remove this gem, these dependencies will not be met."
    msg << "Continue with Uninstall?"
    ask_yes_no(msg.join("\n"), false)
  end

  ##
  # Returns the formatted version of the executable +filename+

  def formatted_program_filename(filename) # :nodoc:
    # TODO perhaps the installer should leave a small manifest
    # of what it did for us to find rather than trying to recreate
    # it again.
    if @format_executable
      require_relative "installer"
      Gem::Installer.exec_format % File.basename(filename)
    else
      filename
    end
  end

  def safe_delete(&block)
    block.call
  rescue Errno::ENOENT
    nil
  rescue Errno::EPERM
    e = Gem::UninstallError.new
    e.spec = @spec

    raise e
  end

  private

  def rm_r(path, exclusions:)
    FileUtils::Entry_.new(path).postorder_traverse do |ent|
      ent.remove unless exclusions.include?(ent.path)
    end
  end

  def specification_record
    @specification_record ||= @install_dir ? Gem::SpecificationRecord.from_path(@install_dir) : Gem::Specification.specification_record
  end

  def announce_deletion_of(spec)
    name = spec.full_name
    say "Successfully uninstalled #{name}"
    if default_spec_matches?(spec)
      say(
        "There was both a regular copy and a default copy of #{name}. The " \
          "regular copy was successfully uninstalled, but the default copy " \
          "was left around because default gems can't be removed."
      )
    end
  end

  # @return true if the specs of any default gems are `==` to the given `spec`.
  def default_spec_matches?(spec)
    !default_specs_that_match(spec).empty?
  end

  # @return [Array] specs of default gems that are `==` to the given `spec`.
  def default_specs_that_match(spec)
    @default_specs_matching_uninstall_params.select {|default_spec| spec == default_spec }
  end

  def warn_cannot_uninstall_default_gems(specs)
    specs.each do |spec|
      say "Gem #{spec.full_name} cannot be uninstalled because it is a default gem"
    end
  end

  def plugin_dir_for(spec)
    Gem.plugindir(spec.base_dir)
  end
end
                                                                                     rubygems/rubygems/uri_formatter.rb                                                                  0000644                 00000001420 15040313421 0013433 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The UriFormatter handles URIs from user-input and escaping.
#
#   uf = Gem::UriFormatter.new 'example.com'
#
#   p uf.normalize #=> 'http://example.com'

class Gem::UriFormatter
  ##
  # The URI to be formatted.

  attr_reader :uri

  ##
  # Creates a new URI formatter for +uri+.

  def initialize(uri)
    require "cgi"

    @uri = uri
  end

  ##
  # Escapes the #uri for use as a CGI parameter

  def escape
    return unless @uri
    CGI.escape @uri
  end

  ##
  # Normalize the URI by adding "http://" if it is missing.

  def normalize
    /^(https?|ftp|file):/i.match?(@uri) ? @uri : "http://#{@uri}"
  end

  ##
  # Unescapes the #uri which came from a CGI parameter

  def unescape
    return unless @uri
    CGI.unescape @uri
  end
end
                                                                                                                                                                                                                                                rubygems/rubygems/package/tar_reader/entry.rb                                                       0000644                 00000010571 15040313421 0015424 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# rubocop:disable Style/AsciiComments

# Copyright (C) 2004 Mauricio Julio Fernández Pradier
# See LICENSE.txt for additional licensing information.

# rubocop:enable Style/AsciiComments

##
# Class for reading entries out of a tar file

class Gem::Package::TarReader::Entry
  ##
  # Creates a new tar entry for +header+ that will be read from +io+
  # If a block is given, the entry is yielded and then closed.

  def self.open(header, io, &block)
    entry = new header, io
    return entry unless block_given?
    begin
      yield entry
    ensure
      entry.close
    end
  end

  ##
  # Header for this tar entry

  attr_reader :header

  ##
  # Creates a new tar entry for +header+ that will be read from +io+

  def initialize(header, io)
    @closed = false
    @header = header
    @io = io
    @orig_pos = @io.pos
    @end_pos 