ty, but is recommended. Use an license identifier from
https://spdx.org/licenses or '#{Gem::Licenses::NONSTANDARD}' for a nonstandard license,
or set it to nil if you don't want to specify a license.
    WARNING
  end

  LAZY = '"FIxxxXME" or "TOxxxDO"'.gsub(/xxx/, "")
  LAZY_PATTERN = /\AFI XME|\ATO DO/x
  HOMEPAGE_URI_PATTERN = /\A[a-z][a-z\d+.-]*:/i

  def validate_lazy_metadata
    unless @specification.authors.grep(LAZY_PATTERN).empty?
      error "#{LAZY} is not an author"
    end

    unless Array(@specification.email).grep(LAZY_PATTERN).empty?
      error "#{LAZY} is not an email"
    end

    if LAZY_PATTERN.match?(@specification.description)
      error "#{LAZY} is not a description"
    end

    if LAZY_PATTERN.match?(@specification.summary)
      error "#{LAZY} is not a summary"
    end

    homepage = @specification.homepage

    # Make sure a homepage is valid HTTP/HTTPS URI
    if homepage && !homepage.empty?
      require_relative "vendor/uri/lib/uri"
      begin
        homepage_uri = Gem::URI.parse(homepage)
        unless [Gem::URI::HTTP, Gem::URI::HTTPS].member? homepage_uri.class
          error "\"#{homepage}\" is not a valid HTTP URI"
        end
      rescue Gem::URI::InvalidURIError
        error "\"#{homepage}\" is not a valid HTTP URI"
      end
    end
  end

  def validate_values
    %w[author homepage summary files].each do |attribute|
      validate_attribute_present(attribute)
    end

    if @specification.description == @specification.summary
      warning "description and summary are identical"
    end

    # TODO: raise at some given date
    warning "deprecated autorequire specified" if @specification.autorequire

    @specification.executables.each do |executabl