ersion` gemspec attribute"
    end
  end

  ##
  # Issues a warning for each file to be packaged which is world-readable.
  #
  # Implementation for Specification#validate_permissions

  def validate_permissions
    return if Gem.win_platform?

    @specification.files.each do |file|
      next unless File.file?(file)
      next if File.stat(file).mode & 0o444 == 0o444
      warning "#{file} is not world-readable"
    end

    @specification.executables.each do |name|
      exec = File.join @specification.bindir, name
      next unless File.file?(exec)
      next if File.stat(exec).executable?
      warning "#{exec} is not executable"
    end
  end

  private

  def validate_nil_attributes
    nil_attributes = Gem::Specification.non_nil_attributes.select do |attrname|
      @specification.instance_variable_get("@#{attrname}").nil?
    end
    return if nil_attributes.empty?
    error "#{nil_attributes.join ", "} must not be nil"
  end

  def validate_rubygems_version
    return unless packaging

    rubygems_version = @specification.rubygems_version

    return if rubygems_version == Gem::VERSION

    warning "expected RubyGems version #{Gem::VERSION}, was #{rubygems_version}"

    @specification.rubygems_version = Gem::VERSION
  end

  def validate_required_attributes
    Gem::Specification.required_attributes.each do |symbol|
      unless @specification.send symbol
        error "missing value for attribute #{symbol}"
      end
    end
  end

  def validate_name
    name = @specification.name

    if !name.is_a?(String)
      error "invalid value for attribute name: \"#{name.inspect}\" must be a string"
    elsif !/[a-zA-Z]/.match?(name)
      error "invalid value for attribute name: #{name.dump} must include at least one letter"
    elsif !VALID_NAME_PATTERN.match?(name)
      error "invalid value for attribute name: #{name.dump} can only include letters, numbers, dashes, and underscores"
    elsif SPECIAL_CHARACTERS.match?(name)
      error "invalid value for attribute name: #{name.dump} cannot begin with a period, dash, or underscore"
    end
  end

  def validate_require_paths
    return unless @specification.raw_require_paths.empty?

    error "specification must have at least one require_path"
  end

  def validate_non_files
    return unless packaging

    non_files = @specification.files.reject {|x| File.file?(x) || File.symlink?(x) }

    unless non_files.empty?
      error "[\"#{non_files.join "\", \""}\"] are not files"
    end
  end

  def validate_self_inclusion_in_files_list
    file_name = @specification.file_name

    return unless @specification.files.include?(file_name)

    error "#{@specification.full_name} contains itself (#{file_name}), check your files list"
  end

  def validate_specification_version
    return if @specification.specification_version.is_a?(Integer)

    error "specification_version must be an Integer (did you mean version?)"
  end

  def validate_platform
    platform = @specification.platform

    case platform
    when Gem::Platform, Gem::Platform::RUBY # ok
    else
      error "invalid platform #{platform.inspect}, see Gem::Platform"
    end
  end

  def validate_array_attributes
    Gem::Specification.array_attributes.each do |field|
      validate_array_attribute(field)
    end
  end

  def validate_array_attribute(field)
    val = @specification.send(field)
    klass = case field
            when :dependencies then
              Gem::Dependency
            else
              String
    end

    unless Array === val && val.all? {|x| x.is_a?(klass) || (field == :licenses && x.nil?) }
      error "#{field} must be an Array of #{klass}"
    end
  end

  def validate_authors_field
    return unless @specification.authors.empty?

    error "authors may not be empty"
  end

  def validate_licenses_length
    licenses = @specification.licenses

    licenses.each do |license|
      next if license.nil?

      if license.length > 64
        error "each license must be 64 characters or less"
      end
    end
  end

  def validate_licenses
    licenses = @specification.licenses

    licenses.each do |license|
      next if Gem::Licenses.match?(license) || license.nil?
      license_id_deprecated = Gem::Licenses.deprecated_license_id?(license)
      exception_id_deprecated = Gem::Licenses.deprecated_exception_id?(license)
      suggestions = Gem::Licenses.suggestions(license)

      if li