d in the future.")
    end
  end

  def validate_extensions # :nodoc:
    require_relative "ext"
    builder = Gem::Ext::Builder.new(@specification)

    validate_rake_extensions(builder)
    validate_rust_extensions(builder)
  end

  def validate_rust_extensions(builder) # :nodoc:
    rust_extension = @specification.extensions.any? {|s| builder.builder_for(s).is_a? Gem::Ext::CargoBuilder }
    missing_cargo_lock = !@specification.files.any? {|f| f.end_with?("Cargo.lock") }

    error <<-ERROR if rust_extension && missing_cargo_lock
You have specified rust based extension, but Cargo.lock is not part of the gem files. Please run `cargo generate-lockfile` or any other command to generate Cargo.lock and ensure it is added to your gem files section in gemspec.
    ERROR
  end

  def validate_rake_extensions(builder) # :nodoc:
    rake_extension = @specification.extensions.any? {|s| builder.builder_for(s) == Gem::Ext::RakeBuilder }
    rake_dependency = @specification.dependencies.any? {|d| d.name == "rake" && d.type == :runtime }

    warning <<-WARNING if rake_extension && !rake_dependency
You have specified rake based extension, but rake is not added as runtime dependency. It is recommended to add rake as a runtime dependency in gemspec since there's no guarantee rake will be already installed.
    WARNING
  end

  def validate_unique_links
    links = @specification.metadata.slice(*METADATA_LINK_KEYS)
    grouped = links.group_by {|_key, uri| uri }
    grouped.each do |uri, copies|
      next unless copies.length > 1
      keys = copies.map(&:first).join("\n  ")
      warning <<~WARNING
        You have specified the uri:
          #{uri}
        for all of the following keys:
          #{keys}
        Only the first one will be shown on rubygems.org
      WARNING
    end
  end

  def warning(statement) # :nodoc:
    @warnings += 1

    alert_warning statement
  end

  def error(statement) # :nodoc:
    raise Gem::InvalidSpecificationException, statement
  ensure
    alert_warning help_text
  end

  def help_text # :nodoc:
    "See https://guides.rubygems.org/specification-reference/ for help"
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                    rubygems/rubygems/uninstaller.rb                                                                    0000644                 00000025653 15040313421 0013127 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require "fileutils"
require_relative "../rubygems"
require_relative "installer_uninstaller_utils"
require_relative "dependency_list"
require_relative "user_interaction"

##
# An Uninstaller.
#
# The uninstaller fires pre and post uninstall hooks.  Hooks can be added
# either through a rubygems_plugin.rb file in an installed gem or via a
# rubygems/defaults/#{RUBY_ENGINE}.rb or rubygems/defaults/operating_system.rb
# file.  See Gem.pre_uninstall and Gem.post_uninstall for details.

class Gem::Uninstaller
  include Gem::UserInteraction

  include Gem::InstallerUninstallerUtils

  ##
  # The directory a gem's executables will be installed into

  attr_reader :bin_dir

  ##
  # The gem repository the gem will be uninstalled from

  attr_reader :gem_home

  ##
  # The Gem::Specification for the gem being uninstalled, only set during
  # #uninstall_gem

  attr_reader :spec

  ##
  # Constructs an uninstaller that will uninstall +gem+

  def initialize(gem, options = {})
    # TODO: document the valid options
    @gem                = gem
    @version            = options[:version] || Gem::Requirement.default
    @install_dir        = options[:install_dir]
    @gem_home           = File.realpath(@install_dir || Gem.dir)
    @user_dir           = File.exist?(Gem.user_dir) ? File.realpath(Gem.user_dir) : Gem.user_dir
    @force_executables  = options[:executables]
    @force_all          = options[:all]
    @force_ignore       = options[:ignore]
    @bin_dir            = options[:bin_dir]
    @format_executable  = options[:format_executable]
    @abort_on_dependent = options[:abort_on_dependent]

    # Indicate if development dependencies should be checked when
    # uninstalling. (default: false)
    #
    @check_dev = options[:check_dev]

    if options[:force]
      @force_all = true
      @force_ignore = true
    end

    # only add user directory if install_dir is not set
    @user_install = false
    @user_install = options[:user_install] unless @install_dir

    # Optimization: populated during #uninstall
    @default_specs_matching_uninstall_params = []
  end

  ##
  # Performs the uninstall of the gem.  This removes the spec, the Gem
  # directory, and the cached .gem file.

  def uninstall
    dependency = Gem::Dependency.new @gem, @version

    list = []

    specification_record.stubs.each do |spec|
      next unless dependency.matches_spec? spec

      list << spec
    end

    if list.empty?
      raise Gem::InstallError, "gem #{@gem.inspect} is not installed"
    end

    default_specs, list = list.partition(&:default_gem?)
    warn_cannot_uninstall_default_gems(default_specs - list)
    @default_specs_matching_uninstall_params = default_specs.map(&:to_spec)

    list, other_repo_specs = list.partition do |spec|
      @gem_home == spec.base_dir ||
        (@user_install && spec.base_dir == @user_dir)
    end

    list.sort!

    if list.empty?
      return unless other_repo_specs.any?

      other_repos = other_repo_specs.map(&:base_dir).uniq

      message = ["#{@gem} is not installed in GEM_HOME, try:"]
      message.concat other_repos.map {|repo|
        "\tgem uninstall -i #{repo} #{@gem}"
      }

      raise Gem::InstallError, message.join("\n")
    elsif @force_all
      remove_all list

    elsif list.size > 1
      gem_names = list.map(&:full_name_with_location)
      gem_names << "All versions"

      say
      _, index = choose_from_list "Select gem to uninstall:", gem_names

      if index == list.size
        remove_all list
      elsif index && index >= 0 && index < list.size
        uninstall_gem list[index]
      else
        say "Error: must enter a number [1-#{list.size + 1}]"
      end
    else
      uninstall_gem list.first
    end
  end

  ##
  # Uninstalls gem +spec+

  def uninstall_gem(stub)
    spec = stub.to_spec

    @spec = spec

    unless dependencies_ok? spec
      if abort_on_dependent? || !ask_if_ok(spec)
        raise Gem::DependencyRemovalException,
          "Uninstallation aborted due to dependent gem(s)"
      end
    end

    Gem.pre_uninstall_hooks.each do |hook|
      hook.call self
    end

    remove_executables @spec
    remove_plugins @spec
    remove @spec

    specification_record.remove_spec(stub)

    regenerate_plugins

    Gem.post_uninstall_hooks.each do |hook|
      hook.call self
    end

    @spec = nil
  end

  ##
  # Removes installed executables and batch files (windows only) for +spec+.

  def remove_exec