an be lazy and just say
    # it's documentation. Ideally the hook adder could decide whether to be in
    # the background or not, and what to call it.
    in_background "Installing documentation" do
      Gem.done_installing_hooks.each do |hook|
        hook.call self, @installed_gems
      end
    end unless Gem.done_installing_hooks.empty?

    @installed_gems
  end

  def install_development_deps # :nodoc:
    if @development && @dev_shallow
      :shallow
    elsif @development
      :all
    else
      :none
    end
  end

  def resolve_dependencies(dep_or_name, version) # :nodoc:
    request_set = Gem::RequestSet.new
    request_set.development         = @development
    request_set.development_shallow = @dev_shallow
    request_set.soft_missing = @force
    request_set.prerelease = @prerelease

    installer_set = Gem::Resolver::InstallerSet.new @domain
    installer_set.ignore_installed = (@minimal_deps == false) || @only_install_dir
    installer_set.force = @force

    if consider_local?
      if dep_or_name =~ /\.gem$/ && File.file?(dep_or_name)
        src = Gem::Source::SpecificFile.new dep_or_name
        installer_set.add_local dep_or_name, src.spec, src
        version = src.spec.version if version == Gem::Requirement.default
      elsif dep_or_name =~ /\.gem$/ # rubocop:disable Performance/RegexpMatch
        Dir[dep_or_name].each do |name|
          src = Gem::Source::SpecificFile.new name
          installer_set.add_local dep_or_name, src.spec, src
        rescue Gem::Package::FormatError
        end
        # else This is a dependency. InstallerSet handles this case
      end
    end

    dependency =
      if spec = installer_set.local?(dep_or_name)
        installer_set.remote = nil if spec.dependencies.none?
        Gem::Dependency.new spec.name, version
      elsif String