ompares this version with +other+ returning -1, 0, or 1 if the
  # other version is larger, the same, or smaller than this
  # one. Attempts to compare to something that's not a
  # <tt>Gem::Version</tt> or a valid version String return +nil+.

  def <=>(other)
    return self <=> self.class.new(other) if (String === other) && self.class.correct?(other)

    return unless Gem::Version === other
    return 0 if @version == other.version || canonical_segments == other.canonical_segments

    lhsegments = canonical_segments
    rhsegments = other.canonical_segments

    lhsize = lhsegments.size
    rhsize = rhsegments.size
    limit  = (lhsize > rhsize ? rhsize : lhsize)

    i = 0

    while i < limit
      lhs = lhsegments[i]
      rhs = rhsegments[i]
      i += 1

      next      if lhs == rhs
      return -1 if String  === lhs && Numeric === rhs
      return  1 if Numeric === lhs && String  === rhs

      return lhs <=> rhs
    end

    lhs = lhsegments[i]

    if lhs.nil?
      rhs = rhsegments[i]

      while i < rhsize
        return 1 if String === rhs
        return -1 unless rhs.zero?
        rhs = rhsegments[i += 1]
      end
    else
      while i < lhsize
        return -1 if String === lhs
        return 1 unless lhs.zero?
        lhs = lhsegments[i += 1]
      end
    end

    0
  end

  # remove trailing zeros segments before first letter or at the end of the version
  def canonical_segments
    @canonical_segments ||= begin
      # remove trailing 0 segments, using dot or letter as anchor
      # may leave a trailing dot which will be ignored by partition_segments
      canonical_version = @version.sub(/(?<=[a-zA-Z.])[.0]+\z/, "")
      # remove 0 segments before the first letter in a prerelease version
      canonical_version.sub!(/(?<=\.|\A)[0.]+(?=[a-zA-Z])/, "") if prerelease?
      partition_segments(canonical_version)
    end
  end

  def freeze
    prerelease?
    _segments
    canonical_segments
    super
  end

  protected

  def _segments
    # segments is lazy so it can pick up version values that come from
    # old marshaled versions, which don't go through marshal_load.
    # since this version object is cached in @@all, its @segments should be frozen
    @segments ||= partition_segments(@version)
  end

  def partition_segments(ver)
    ver.scan(/\d+|[a-z]+/i).map! do |s|
      /\A\d/.match?(s) ? s.to_i : -s
    end.freeze
  end
end
                                                                                                                                                            rubygems/rubygems/text.rb                                                                           0000644                 00000004102 15040313416 0011541 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A collection of text-wrangling methods

module Gem::Text
  ##
  # Remove any non-printable characters and make the text suitable for
  # printing.
  def clean_text(text)
    text.gsub(/[\000-\b\v-\f\016-\037\177]/, ".")
  end

  def truncate_text(text, description, max_length = 100_000)
    raise ArgumentError, "max_length must be positive" unless max_length > 0
    return text if text.size <= max_length
    "Truncating #{description} to #{max_length.to_s.reverse.gsub(/...(?=.)/,'\&,').reverse} characters:\n" + text[0, max_length]
  end

  ##
  # Wraps +text+ to +wrap+ characters and optionally indents by +indent+
  # characters

  def format_text(text, wrap, indent=0)
    result = []
    work = clean_text(text)

    while work.length > wrap do
      if work =~ /^(.{0,#{wrap}})[ \n]/
        result << $1.rstrip
        work.slice!(0, $&.length)
      else
        result << work.slice!(0, wrap)
      end
    end

    result << work if work.length.nonzero?
    result.join("\n").gsub(/^/, " " * indent)
  end

  def min3(a, b, c) # :nodoc:
    if a < b && a < c
      a
    elsif b < c
      b
    else
      c
    end
  end

  # Returns a value representing the "cost" of transforming str1 into str2
  # Vendored version of DidYouMean::Levenshtein.distance from the ruby/did_you_mean gem @ 1.4.0
  # https://github.com/ruby/did_you_mean/blob/2ddf39b874808685965dbc47d344cf6c7651807c/lib/did_you_mean/levenshtein.rb#L7-L37
  def levenshtein_distance(str1, str2)
    n = str1.length
    m = str2.length
    return m if n.zero?
    return n if m.zero?

    d = (0..m).to_a
    x = nil

    # to avoid duplicating an enumerable object, create it outside of the loop
    str2_codepoints = str2.codepoints

    str1.each_codepoint.with_index(1) do |char1, i|
      j = 0
      while j < m
        cost = char1 == str2_codepoints[j] ? 0 : 1
        x = min3(
          d[j + 1] + 1, # insertion
          i + 1,      # deletion
          d[j] + cost # substitution
        )
        d[j] = i
        i = x

        j += 1
      end
      d[m] = x
    end

    x
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                              rubygems/rubygems/request/connection_pools.rb                                                       0000644                 00000004605 15040313416 0015630 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::Request::ConnectionPools # :nodoc:
  @client = Gem::Net::HTTP

  class << self
    attr_accessor :client
  end

  def initialize(proxy_uri, cert_files)
    @proxy_uri  = proxy_uri
    @cert_files = cert_files
    @pools      = {}
    @pool_mutex = Thread::Mutex.new
  end

  def pool_for(uri)
    http_args = net_http_args(uri, @proxy_uri)
    key       = http_args + [https?(uri)]
    @pool_mutex.synchronize do
      @pools[key] ||=
        if https? uri
          Gem::Request::HTTPSPool.new(http_args, @cert_files, @proxy_uri)
        else
          Gem::Request::HTTPPool.new(http_args, @cert_files, @proxy_uri)
        end
    end
  end

  def close_all
    @pools.each_value(&:close_all)
  end

  private

  ##
  # Returns list of no_proxy entries (if any) from the environment

  def get_no_proxy_from_env
    env_no_proxy = ENV["no_proxy"] || ENV["NO_PROXY"]

    return [] if env_no_proxy.nil? || env_no_proxy.empty?

    env_no_proxy.split(/\s*,\s*/)
  end

  def https?(uri)
    uri.scheme.casecmp("https").zero?
  end

  def no_proxy?(host, env_no_proxy)
    host = host.downcase

    env_no_proxy.any? do |pattern|
      env_no_proxy_pattern = pattern.downcase.dup

      # Remove dot in front of pattern for wildcard matching
      env_no_proxy_pattern[0] = "" if env_no_proxy_pattern[0] == "."

      host_tokens = host.split(".")
      pattern_tokens = env_no_proxy_pattern.split(".")

      intersection = (host_tokens - pattern_tokens) | (pattern_tokens - ho