 = proxy_uri.respond_to?(:hostname) ? proxy_uri.hostname : proxy_uri.host
      net_http_args + [
        proxy_hostname,
        proxy_uri.port,
        Gem::UriFormatter.new(proxy_uri.user).unescape,
        Gem::UriFormatter.new(proxy_uri.password).unescape,
      ]
    elsif no_proxy? hostname, no_proxy
      net_http_args + [nil, nil]
    else
      net_http_args
    end
  end
end
                                                                                                                           rubygems/rubygems/request/https_pool.rb                                                             0000644                 00000000353 15040313416 0014444 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::Request::HTTPSPool < Gem::Request::HTTPPool # :nodoc:
  private

  def setup_connection(connection)
    Gem::Request.configure_connection_for_https(connection, @cert_files)
    super
  end
end
                                                                                                                                                                                                                                                                                     rubygems/rubygems/request/http_pool.rb                                                              0000644                 00000002020 15040313416 0014252 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A connection "pool" that only manages one connection for now.  Provides
# thread safe `checkout` and `checkin` methods.  The pool consists of one
# connection that corresponds to `http_args`.  This class is private, do not
# use it.

class Gem::Request::HTTPPool # :nodoc:
  attr_reader :cert_files, :proxy_uri

  def initialize(http_args, cert_files, proxy_uri)
    @http_args  = http_args
    @cert_files = cert_files
    @proxy_uri  = proxy_uri
    @queue      = Thread::SizedQueue.new 1
    @queue << nil
  end

  def checkout
    @queue.pop || make_connection
  end

  def checkin(connection)
    @queue.push connection
  end

  def close_all
    until @queue.empty?
      if (connection = @queue.pop(true)) && connection.started?
        connection.finish
      end
    end
    @queue.push(nil)
  end

  private

  def make_connection
    setup_connection Gem::Request::ConnectionPools.client.new(*@http_args)
  end

  def setup_connection(connection)
    connection.start
    connection
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                rubygems/rubygems/platform.rb                                                                       0000644                 00000020640 15040313416 0012406 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "deprecate"

##
# Available list of platforms for targeting Gem installations.
#
# See `gem help platform` for information on platform matching.

class Gem::Platform
  @local = nil

  attr_accessor :cpu, :os, :version

  def self.local(refresh: false)
    return @local if @local && !refresh
    @local = begin
      arch = Gem.target_rbconfig["arch"]
      arch = "#{arch}_60" if /mswin(?:32|64)$/.match?(arch)
      new(arch)
    end
  end

  def self.match(platform)
    match_platforms?(platform, Gem.platforms)
  end

  class << self
    extend Gem::Deprecate
    rubygems_deprecate :match, "Gem::Platform.match_spec? or match_gem?"
  end

  def self.match_platforms?(platform, platforms)
    platform = Gem::Platform.new(platform) unless platform.is_a?(Gem::Platform)
    platforms.any? do |local_platform|
      platform.nil? ||
        local_platform == platform ||
        (local_platform != Gem::Platform::RUBY && platform =~ local_platform)
    end
  end
  private_class_method :match_platforms?

  def self.match_spec?(spec)
    match_gem?(spec.platform, spec.name)
  end

  if RUBY_ENGINE == "truffleruby"
    def self.match_gem?(platform, gem_name)
      raise "Not a string: #{gem_name.inspect}" unless String === gem_name

      if REUSE_AS_BINARY_ON_TRUFFLERUBY.include?(gem_name)
        match_platforms?(platform, [Gem::Platform::RUBY, Gem::Platform.local])
      else
        match_platforms?(platform, Gem.platforms)
      end
    end
  else
    def self.match_gem?(platform, gem_name)
      match_platforms?(platform, Gem.platforms)
    end
  end

  def self.sort_priority(platform)
    platform == Gem::Platform::RUBY ? -1 : 1
  end

  def self.installable?(spec)
    if spec.respond_to? :installable_platform?
      spec.installable_platform?
    else
      match_spec? spec
    end
  end

  def self.new(arch) # :nodoc:
    case arch
    when Gem::Platform::CURRENT then
      Gem::Platform.local
    when Gem::Platform::RUBY, nil, "" then
      Gem::Platform::RUBY
    else
      super
    end
  end

  def initialize(arch)
    case arch
    when Array then
      @cpu, @os, @version = arch
    when String then
      arch = arch.split "-"

      if arch.length > 2 && !arch.last.match?(/\d+(\.\d+)?$/) # reassemble x86-linux-{libc}
        extra = arch.pop
        arch.last << "-#{extra}"
      end

      cpu = arch.shift

      @cpu = case cpu
             when /i\d86/ then "x86"
             else cpu
      end

      if arch.length == 2 && arch.last.match?(/^\d+(\.\d+)?$/) # for command-line
        @os, @version = arch
        return
      end

      os, = arch
      if os.nil?
        @cpu = nil
        os = cpu
      end # legacy jruby

      @os, @version = case os
                      when /aix(\d+)?/ then             ["aix",       $1]
                      when /cygwin/ then                ["cygwin",    nil]
                      when /darwin(\d+)?/ then          ["darwin",    $1]
                      when /^macruby$/ then             ["macruby",   nil]
                      when /freebsd(\d+)?/ then         ["freebsd",   $1]
                      when /^java$/, /^jruby$/ then     ["java",      nil]
                      when /^java([\d.]*)/ then         ["java",      $1]
                      when /^dalvik(\d+)?$/ then        ["dalvik",    $1]
                      when /^dotnet$/ then              ["dotnet",    nil]
                      when /^dotnet([\d.]*)/ then       ["dotnet",    $1]
                      when /linux-?(\w+)?/ then         ["linux",     $1]
                      when /mingw32/ then               ["mingw32",   nil]
                      when /mingw-?(\w+)?/ then         ["mingw",     $1]
                      when /(mswin\d+)(\_(\d+))?/ then
                        os = $1
                        version = $3
                        @cpu = "x86" if @cpu.nil? && os =~ /32$/
                        [os, version]
                      when /netbsdelf/ then             ["netbsdelf", nil]
                      when /openbsd(\d+\.\d+)?/ then    ["openbsd",   $1]
                      when /solaris(\d+\.\d+)?/ then    ["solaris",   $1]
                      when /wasi/ then                  ["wasi",      nil]
                      # test
                      when /^(\w+_platform)(\d+)?/ then [$1,          $2]
                      else ["unknown", nil]
      end
    when Gem::Platform then
      @cpu = arch.cpu
      @os = arch.os
      @version = arch.version
    else
      raise ArgumentError, "invalid argument #{arch.inspect}"
    end
  end

  def to_a
  