rubygems/rubygems/source/local.rb                                                                   0000644                 00000005425 15040313422 0013155 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# The local source finds gems in the current directory for fulfilling
# dependencies.

class Gem::Source::Local < Gem::Source
  def initialize # :nodoc:
    @specs   = nil
    @api_uri = nil
    @uri     = nil
    @load_specs_names = {}
  end

  ##
  # Local sorts before Gem::Source and after Gem::Source::Installed

  def <=>(other)
    case other
    when Gem::Source::Installed,
         Gem::Source::Lock then
      -1
    when Gem::Source::Local then
      0
    when Gem::Source then
      1
    end
  end

  def inspect # :nodoc:
    keys = @specs ? @specs.keys.sort : "NOT LOADED"
    format("#<%s specs: %p>", self.class, keys)
  end

  def load_specs(type) # :nodoc:
    @load_specs_names[type] ||= begin
      names = []

      @specs = {}

      Dir["*.gem"].each do |file|
        pkg = Gem::Package.new(file)
        spec = pkg.spec
      rescue SystemCallError, Gem::Package::FormatError
        # ignore
      else
        tup = spec.name_tuple
        @specs[tup] = [File.expand_path(file), pkg]

        case type
        when :released
          unless pkg.spec.version.prerelease?
            names << pkg.spec.name_tuple
          end
        when :prerelease
          if pkg.spec.version.prerelease?
            names << pkg.spec.name_tuple
          end
        when :latest
          tup = pkg.spec.name_tuple

          cur = names.find {|x| x.name == tup.name }
          if !cur
            names << tup
          elsif cur.version < tup.version
            names.delete cur
            names << tup
          end
        else
          names << pkg.spec.name_tuple
        end
      end

      names
    end
  end

  def find_gem(gem_name, version = Gem::Requirement.default, prerelease = false) # :nodoc:
    load_specs :complete

    found = []

    @specs.each do |n, data|
      next unless n.name == gem_name
      s = data[1].spec

      if version.satisfied_by?(s.version)
        if prerelease
          found << s
        elsif !s.version.prerelease? || version.prerelease?
          found << s
        end
      end
    end

    found.max_by(&:version)
  end

  def fetch_spec(name) # :nodoc:
    load_specs :complete

    if data = @specs[name]
      data.last.spec
    else
      raise Gem::Exception, "Unable to find spec for #{name.inspect}"
    end
  end

  def download(spec, cache_dir = nil) # :nodoc:
    load_specs :complete

    @specs.each do |_name, data|
      return data[0] if data[1].spec == spec
    end

    raise Gem::Exception, "Unable to find file for '#{spec.full_name}'"
  end

  def pretty_print(q) # :nodoc:
    q.object_group(self) do
      q.group 2, "[Local gems:", "]" do
        q.breakable
        if @specs
          q.seplist @specs.keys do |v|
            q.text v.full_name
          end
        end
      end
    end
  end
end
                                                                                                                                                                                                                                           rubygems/rubygems/source/vendor.rb                                                                  0000644                 00000000701 15040313422 0013350 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# This represents a vendored source that is similar to an installed gem.

class Gem::Source::Vendor < Gem::Source::Installed
  ##
  # Creates a new Vendor source for a gem that was unpacked at +path+.

  def initialize(path)
    @uri = path
  end

  def <=>(other)
    case other
    when Gem::Source::Lock then
      -1
    when Gem::Source::Vendor then
      0
    when Gem::Source then
      1
    end
  end
end
                                                               rubygems/rubygems/source/installed.rb                                                               0000644                 00000001251 15040313422 0014033 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Represents an installed gem.  This is used for dependency resolution.

class Gem::Source::Installed < Gem::Source
  def initialize # :nodoc:
    @uri = nil
  end

  ##
  # Installed sources sort before all other sources

  def <=>(other)
    case other
    when Gem::Source::Git,
         Gem::Source::Lock,
         Gem::Source::Vendor then
      -1
    when Gem::Source::Installed then
      0
    when Gem::Source then
      1
    end
  end

  ##
  # We don't need to download an installed gem

  def download(spec, path)
    nil
  end

  def pretty_print(q) # :nodoc:
    q.object_group(self) do
      q.text "[Installed]"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                       rubygems/rubygems/source/lock.rb                                                                    0000644                 00000001614 15040313422 0013007 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A Lock source wraps an installed gem's source and sorts before other sources
# during dependency resolution.  This allows RubyGems to prefer gems from
# dependency lock files.

class Gem::Source::Lock < Gem::Source
  ##
  # The wrapped Gem::Source

  attr_reader :wrapped

  ##
  # Creates a new Lock source that wraps +source+ and moves it earlier in the
  # sort list.

  def initialize(source)
    @wrapped = source
  end

  def <=>(other) # :nodoc:
    case other
    when Gem::Source::Lock then
      @wrapped <=> other.wrapped
    when Gem::Source then
      1
    end
  end

  def ==(other) # :nodoc:
    (self <=> other) == 0
  end

  def hash # :nodoc:
    @wrapped.hash ^ 3
  end

  ##
  # Delegates to the wrapped source's fetch_spec method.

  def fetch_spec(name_tuple)
    @wrapped.fetch_spec name_tuple
  end

  def uri # :nodoc:
    @wrapped.uri
  end
end
                                                                                                                    rubygems/rubygems/config_file.rb                                                                    0000644                 00000040474 15040313422 0013032 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

require_relative "user_interaction"
require "rbconfig"

##
# Gem::ConfigFile RubyGems options and gem command options from gemrc.
#
# gemrc is a YAML file that uses strings to match gem command arguments and
# symbols to match RubyGems options.
#
# Gem command arguments use a String key that matches the command name and
# allow you to specify default arguments:
#
#   install: --no-rdoc --no-ri
#   update: --no-rdoc --no-ri
#
# You can use <tt>gem:</tt> to set default arguments for all commands.
#
# RubyGems options use symbol keys.  Valid options are:
#
# +:backtrace+:: See #backtrace
# +:sources+:: Sets Gem::sources
# +:verbose+:: See #verbose
# +:concurrent_downloads+:: See #concurrent_downloads
#
# gemrc files may exist in various locations and are read and merged in
# the following order:
#
# - system wide (/etc/gemrc)
# - per user (~/.gemrc)
# - per environment (gemrc files listed in the GEMRC environment variable)

class Gem::ConfigFile
  include Gem::UserInteraction

  DEFAULT_BACKTRACE = true
  DEFAULT_BULK_THRESHOLD = 1000
  DEFAULT