or => e
        details = "#{plugin.inspect}: #{e.message} (#{e.class})"
        warn "Error loading RubyGems plugin #{details}"
      end
    end
  end

  ##
  # Find rubygems plugin files in the standard location and load them

  def self.load_plugins
    Gem.path.each do |gem_path|
      load_plugin_files Gem::Util.glob_files_in_dir("*#{Gem.plugin_suffix_pattern}", plugindir(gem_path))
    end
  end

  ##
  # Find all 'rubygems_plugin' files in $LOAD_PATH and load them

  def self.load_env_plugins
    load_plugin_files find_files_from_load_path("rubygems_plugin")
  end

  ##
  # Looks for a gem dependency file at +path+ and activates the gems in the
  # file if found.  If the file is not found an ArgumentError is raised.
  #
  # If +path+ is not given the RUBYGEMS_GEMDEPS environment variable is used,
  # but if no file is found no exception is raised.
  #
  # If '-' is given for +path+ RubyGems searches up from the current working
  # directory for gem dependency files (gem.deps.rb, Gemfile, Isolate) and
  # activates the gems in the first one found.
  #
  # You can run this automatically when rubygems starts.  To enable, set
  # the <code>RUBYGEMS_GEMDEPS</code> environment variable to either the path
  # of your gem dependencies file or "-" to auto-discover in parent
  # directories.
  #
  # NOTE: Enabling automatic discovery on multiuser systems can lead to
  # execution of arbitrary code when used from directories outside your
  # control.

  def self.use_gemdeps(path = nil)
    raise_exception = path

    path ||= ENV["RUBYGEMS_GEMDEPS"]
    return unless path

    path = path.dup

    if path == "-"
      Gem::Util.traverse_parents Dir.pwd do |directory|
        dep_file = GEM_DEP_FILES.find {|f| File.file?(f) }

        next unless dep_file

        path = File.join directory, dep_file
        break
      end
    end

    unless File.file? path
      return unless raise_exception

      raise ArgumentError, "Unable to find gem dependencies file at #{path}"
    end

    ENV["BUNDLE_GEMFILE"] ||= File.expand_path(path)
    require_relative "rubygems/user_interaction"
    require "bundler"
    begin
      Gem::DefaultUserInteraction.use_ui(ui) do
        Bundler.ui.silence do
          @gemdeps = Bundler.setup
        end
      ensure
        Gem::DefaultUserInteraction.ui.close
      end
    rescue Bundler::BundlerError => e
      warn e.message
      warn "You may need to `bundle install` to install missing gems"
      warn ""
    end
  end

  ##
  # If the SOURCE_DATE_EPOCH environment variable is set, returns it's value.
  # Otherwise, returns DEFAULT_SOURCE_DATE_EPOCH as a string.
  #
  # NOTE(@duckinator): The implementation is a tad weird because we want to:
  #   1. Make builds reproducible by default, by having this function always
  #      return the same result during a given run.
  #   2. Allow changing ENV['SOURCE_DATE_EPOCH'] at runtime, since multiple
  #      tests that set this variable will be run in a single process.
  #
  # If you simplify this function and a lot of tests fail, that is likely
  # due to #2 above.
  #
  # Details on SOURCE_DATE_EPOCH:
  # https://reproducible-builds.org/specs/source-date-epoch/

  def self.source_date_epoch_string
    specified_epoch = ENV["SOURCE_DATE_EPOCH"]

    # If it's empty or just whitespace, treat it like it wasn't set at all.
    specified_epoch = nil if !specified_epoch.nil? && specified_epoch.strip.empty?

    epoch = specified_epoch || DEFAULT_SOURCE_DATE_EPOCH.to_s

    epoch.strip
  end

  ##
  # Returns the value of Gem.source_date_epoch_string, as a Time object.
  #
  # This is used throughout RubyGems for enabling reproducible builds.

  def self.source_date_epoch
    Time.at(source_date_epoch_string.to_i).utc.freeze
  end

  # FIX: Almost everywhere else we use the `def self.` way of defining class
  # methods, and then we switch over to `class << self` here. Pick one or the
  # other.
  class << self
    ##
    # RubyGems distributors (like operating system package managers) can
    # disable RubyGems update by setting this to error message printed to
    # end-users on gem update --system instead of actual update.

    attr_accessor :disable_system_update_message

    ##
    # Whether RubyGems should enhance builtin `require` to automatically
    # check whether the path required is present in installed gems, and
    # automatically activate them and add them to `$LOAD_PATH`.

    attr_accessor :discover_gems_on_require

    ##
    # Hash of loaded Gem::Specification keyed by name

    attr_reader :loaded_specs

    ##
    # GemDependencyAPI object, which is set when .use_gemdeps is called.
    # This contains all the information from the Gemfile.

    attr_reader :gemdeps

    ##
    # Register a Gem::Specification for default gem.
    #
    # Two formats for the specification are supported:
    #
    # * MRI 2.0 style, where spec.files contains unprefixed require names.
    #   The spec's filenames will be registered as-is.
    # * New style, where spec.files contains files prefixed with paths
    #   from spec.require_paths. The prefixes are stripped before
    #   registering the spec's filenames. Unprefixed files are omitted.
    #

    def register_default_spec(spec)
      extended_require_paths = spec.require_paths.map {|f| f + "/" }
      new_format = extended_require_paths.any? {|path| spec.files.any? {|f| f.start_with? path } }

      if new_format
        prefix_group = extended_require_paths.join("|")
        prefix_pattern = /^(#{prefix_group})/
      end

      spec.files.each do |file|
        if new_format
          file = file.sub(prefix_pattern, "")
          next unless $~
        end

        spec.activate if already_loaded?(file)

        @path_to_default_spec_map[file] = spec
        @path_to_default_spec_map[file.sub(suffix_regexp, "")] = spec
      end
    end

    ##
    # Find a Gem::Specification of default gem from +path+

    def find_default_spec(path)
      @path_to_default_spec_map[path]
    end

    ##
    # Find an unresolved Gem::Specification of default gem from +path+

    def find_unresolved_default_spec(path)
      default_spec = @path_to_default_spec_map[path]
      default_spec if default_spec && loaded_specs[default_spec.name] != default_spec
    end

    ##
    # Clear default gem related variables. It is for test

    def clear_default_specs
      @path_to_default_spec_map.clear
    end

    ##
    # The list of hooks to be run after Gem::Installer#install extracts files
    # and builds extensions

    attr_reader :post_build_hooks

    ##
    # The list of hooks to be run after Gem::Installer#install completes
    # installation

    attr_reader :post_install_hooks

    ##
    # The list of hooks to be run after Gem::DependencyInstaller installs a
    # set of gems

    attr_reader :done_installing_hooks

    ##
    # The list of hooks to be run after Gem::Specification.reset is run.

    attr_reader :post_reset_hooks

    ##
    # The list of hooks to be run after Gem::Uninstaller#uninstall completes
    # installation

    attr_reader :post_uninstall_hooks

    ##
    # The list of hooks to be run before Gem::Installer#install does any work

    attr_reader :pre_install_hooks

    ##
    # The list of hooks to be run before Gem::Specification.reset is run.

    attr_reader :pre_reset_hooks

    ##
    # The list of hooks to be run before Gem::Uninstaller#uninstall does any
    # work

    attr_reader :pre_uninstall_hooks

    private

    def already_loaded?(file)
      $LOADED_FEATURES.any? do |feature_path|
        feature_path.end_with?(file) && default_gem_load_paths.any? {|load_path_entry| feature_path == "#{load_path_entry}/#{file}" }
      end
    end

    def default_gem_load_paths
      @default_gem_load_paths ||= $LOAD_PATH[load_path_insert_index..-1].map do |lp|
        expanded = File.expand_path(lp)
        next expanded unless File.exist?(expanded)

        File.realpath(expanded)
      end
    end
  end

  ##
  # Location of Marshal quick gemspecs on remote repositories

  MARSHAL_SPEC_DIR = "quick/Marshal.#{Gem.marshal_version}/".freeze

  autoload :ConfigFile,         File.expand_path("rubygems/config_file", __dir__)
  autoload :CIDetector,         File.expand_path("rubygems/ci_detector", __dir__)
  autoload :Dependency,         File.expand_path("rubygems/dependency", __dir__)
  autoload :DependencyList,     File.expand_path("rubygems/dependency_list", __dir__)
  autoload :Installer,          File.expand_path("rubygems/installer", __dir__)
  autoload :Licenses,           File.expand_path("rubygems/util/licenses", __dir__)
  autoload :NameTuple,          File.expand_path("rubygems/name_tuple", __dir__)
  autoload :PathSupport,        File.expand_path("rubygems/path_support", __dir__)
  autoload :RequestSet,         File.expand_path("rubygems/request_set", __dir__)
  autoload :Requirement,        File.expand_path("rubygems/requirement", __dir__)
  autoload :Resolver,           File.expand_path("rubygems/resolver", __dir__)
  autoload :Source,             File.expand_path("rubygems/source", __dir__)
  autoload :SourceList,         File.expand_path("rubygems/source_list", __dir__)
  autoload :SpecFetcher,        File.expand_path("rubygems/spec_fetcher", __dir__)
  autoload :SpecificationPolicy, File.expand_path("rubygems/specification_policy", __dir__)
  autoload :Util,               File.expand_path("rubygems/util", __dir__)
  autoload :Version,            File.expand_path("rubygems/version", __dir__)
end

require_relative "rubygems/exceptions"
require_relative "rubygems/specification"

# REFACTOR: This should be pulled out into some kind of hacks file.
begin
  ##
  # Defaults the operating system (or packager) wants to provide for RubyGems.

  require "rubygems/defaults/operating_system"
rescue LoadError
  # Ignored
rescue StandardError => e
  path = e.backtrace_locations.reverse.find {|l| l.path.end_with?("rubygems/defaults/operating_system.rb") }.path
  msg = "#{e.message}\n" \
    "Loading the #{path} file caused an error. " \
    "This file is owned by your OS, not by rubygems upstream. " \
    "Please find out which OS package this file belongs to and follow the guidelines from your OS to report " \
    "the problem and ask for help."
  raise e.class, msg
end

begin
  ##
  # Defaults the Ruby implementation wants to provide for RubyGems

  require "rubygems/defaults/#{RUBY_ENGINE}"
rescue LoadError
end

##
# Loads the default specs.
Gem::Specification.load_defaults

require_relative "rubygems/core_ext/kernel_gem"

path = File.join(__dir__, "rubygems/core_ext/kernel_require.rb")
# When https://bugs.ruby-lang.org/issues/17259 is available, there is no need to override Kernel#warn
if RUBY_ENGINE == "truffleruby" ||
   RUBY_ENGINE == "ruby"
  file = "<internal:#{path}>"
else
  require_relative "rubygems/core_ext/kernel_warn"
  file = path
end
eval File.read(path), nil, file

require ENV["BUNDLER_SETUP"] if ENV["BUNDLER_SETUP"] && !defined?(Bundler)
                                                                                                                                                                                                                                                                     rubygems/rubygems/request_set.rb                                                                    0000644                 00000026446 15040313416 0013137 0                                                                                                    ustar 00                                                     