rubygems/rubygems/package/old.rb                                                                    0000644                 00000007177 15040313421 0012741 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

#--
# Copyright 2006 by Chad Fowler, Rich Kilmer, Jim Weirich and others.
# All rights reserved.
# See LICENSE.txt for permissions.
#++

##
# The format class knows the guts of the ancient .gem file format and provides
# the capability to read such ancient gems.
#
# Please pretend this doesn't exist.

class Gem::Package::Old < Gem::Package
  undef_method :spec=

  ##
  # Creates a new old-format package reader for +gem+.  Old-format packages
  # cannot be written.

  def initialize(gem, security_policy)
    require "fileutils"
    require "zlib"
    Gem.load_yaml

    @contents        = nil
    @gem             = gem
    @security_policy = security_policy
    @spec            = nil
  end

  ##
  # A list of file names contained in this gem

  def contents
    verify

    return @contents if @contents

    @gem.with_read_io do |io|
      read_until_dashes io # spec
      header = file_list io

      @contents = header.map {|file| file["path"] }
    end
  end

  ##
  # Extracts the files in this package into +destination_dir+

  def extract_files(destination_dir)
    verify

    errstr = "Error reading files from gem"

    @gem.with_read_io do |io|
      read_until_dashes io # spec
      header = file_list io
      raise Gem::Exception, errstr unless header

      header.each do |entry|
        full_name = entry["path"]

        destination = install_location full_name, destination_dir

        file_data = String.new

        read_until_dashes io do |line|
          file_data << line
        end

        file_data = file_data.strip.unpack1("m")
        file_data = Zlib::Inflate.inflate file_data

        raise Gem::Package::FormatError, "#{full_name} in #{@gem} is corrupt" if
          file_data.length != entry["size"].to_i

        FileUtils.rm_rf destination

        FileUtils.mkdir_p File.dirname(destination), mode: dir_mode && 0o755

        File.open destination, "wb", file_mode(entry["mode"]) do |out|
          out.write file_data
        end

        verbose destination
      end
    end
  rescue Zlib::DataError
    raise Gem::Exception, errstr
  end

  ##
  # Reads the file list section from the old-format gem +io+

  def file_list(io) # :nodoc:
    header = String.new

    read_until_dashes io do |line|
      header << line
    end

    Gem::SafeYAML.safe_load header
  end

  ##
  # Reads lines until a "---" separator is found

  def read_until_dashes(io) # :nodoc:
    while (line = io.gets) && line.chomp.strip != "---" do
      yield line if block_given?
    end
  end

  ##
  # Skips the Ruby self-install header in +io+.

  def skip_ruby(io) # :nodoc:
    loop do
      line = io.gets

      return if line.chomp == "__END__"
      break unless line
    end

    raise Gem::Exception, "Failed to find end of Ruby script while reading gem"
  end

  ##
  # The specification for this gem

  def spec
    verify

    return @spec if @spec

    yaml = String.new

    @gem.with_read_io do |io|
      skip_ruby io
      read_until_dashes io do |line|
        yaml << line
      end
    end

    begin
      @spec = Gem::Specification.from_yaml yaml
    rescue Psych::SyntaxError
      raise Gem::Exception, "Failed to parse gem specification out of gem file"
    end
  rescue ArgumentError
    raise Gem::Exception, "Failed to parse gem specification out of gem file"
  end

  ##
  # Raises an exception if a security policy that verifies data is active.
  # Old format gems cannot be verified as signed.

  def verify
    return true unless @security_policy

    raise Gem::Security::Exception,
          "old format gems do not contain signatures and cannot be verified" if
      @security_policy.verify_data

    true
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                 rubygems/rubygems/package/io_source.rb                                                              0000644                 00000001456 15040313421 0014144 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Supports reading and writing gems from/to a generic IO object.  This is
# useful for other applications built on top of rubygems, such as
# rubygems.org.
#
# This is a private class, do not depend on it directly. Instead, pass an IO
# object to `Gem::Package.new`.

class Gem::Package::IOSource < Gem::Package::Source # :nodoc: all
  attr_reader :io

  def initialize(io)
    @io = io
  end

  def start
    @start ||= begin
      if io.pos > 0
        raise Gem::Package::Error, "Cannot read start unless IO is at start"
      end

      value = io.read 20
      io.rewind
      value
    end
  end

  def present?
    true
  end

  def with_read_io
    yield io
  ensure
    io.rewind
  end

  def with_write_io
    yield io
  ensure
    io.rewind
  end

  def path
  end
end
                                                                                                                                                                                                                  rubygems/rubygems/package/digest_io.rb                                                              0000644                 00000002515 15040313421 0014120 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# IO wrapper that creates digests of contents written to the IO it wraps.

class Gem::Package::DigestIO
  ##
  # Collected digests for wrapped writes.
  #
  #   {
  #     'SHA1'   => #<OpenSSL::Digest: [...]>,
  #     'SHA512' => #<OpenSSL::Digest: [...]>,
  #   }

  attr_reader :digests

  ##
  # Wraps +io+ and updates digest for each of the digest algorithms in
  # the +digests+ Hash.  Returns the digests hash.  Example:
  #
  #   io = StringIO.new
  #   digests = {
  #     'SHA1'   => OpenSSL::Digest.new('SHA1'),
  #     'SHA512' => OpenSSL::Digest.new('SHA512'),
  #   }
  #
  #   Gem::Package::DigestIO.wrap io, digests do |digest_io|
  #     digest_io.write "hello"
  #   end
  #
  #   digests['SHA1'].hexdigest   #=> "aaf4c61d[...]"
  #   digests['SHA512'].hexdigest #=> "9b71d224[...]"

  def self.wrap(io, digests)
    digest_io = new io, digests

    yield digest_io

    digests
  end

  ##
  # Creates a new DigestIO instance.  Using ::wrap is recommended, see the
  # ::wrap documentation for documentation of +io+ and +digests+.

  def initialize(io, digests)
    @io = io
    @digests = digests
  end

  ##
  # Writes +data+ to the underlying IO and updates the digests

  def write(data)
    result = @io.write data

    @digests.each do |_, digest|
      digest << data
    end

    result
  end
end
                                                                                                                                                                                   rubygems/rubygems/mock_gem_ui.rb                                                                    0000644                 00000002605 15040313421 0013035 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
      FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
      DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
      OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
      HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
      LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
      OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
      SUCH DAMAGE.

      IMPORTANT                                                                                                                                                                                                                                                      licenses/alt-ruby32-devel/COPYING                                                                   0000644                 00000004573 15040313423 0012411 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       Copyright (C) 1993-2013 Yukihiro Matsumoto. All rights reserved.

Redistributi                                                                                                                           rubygems/rubygems/defaults.rb                                                                       0000644                 00000016606 15040313421 0012374 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Gem
  DEFAULT_HOST = "https://rubygems.org"

  @post_install_hooks ||= []
  @done_installing_hooks ||= []
  @post_uninstall_hooks ||= []
  @pre_uninstall_hooks  ||= []
  @pre_install_hooks    ||= []

  ##
  # An Array of the default sources that come with RubyGems

  def self.default_sources
    %w[https://rubygems.org/]
  end

  ##
  # Default spec directory path to be used if an alternate value is not
  # specified in the environment

  def self.default_spec_cache_dir
    default_spec_cache_dir = File.join Gem.user_home, ".gem", "specs"

    unless File.exist?(default_spec_cache_dir)
      default_spec_cache_dir = File.join Gem.cache_home, "gem", "specs"
    end

    default_spec_cache_dir
  end

  ##
  # Default home directory path to be used if an alternate value is not
  # specified in the environment

  def self.default_dir
    @default_dir ||= File.join(RbConfig::CONFIG["rubylibprefix"], "gems", RbConfig::CONFIG["ruby_version_dir_name"] || RbConfig::CONFIG["ruby_version"])
  end

  ##
  # Returns binary extensions dir for specified RubyGems base dir or nil
  # if such directory cannot be determined.
  #
  # By default, the binary extensions are located side by side with their
  # Ruby counterparts, therefore nil is returned

  def self.default_ext_dir_for(base_dir)
    nil
  end

  ##
  # Paths where RubyGems' .rb files and bin files are installed

  def self.default_rubygems_dirs
    nil # default to standard layout
  end

  ##
  # Path to specification files of default gems.

  def self.default_specifications_dir
    @default_specifications_dir ||= File.join(Gem.default_dir, "specifications", "default")
  end

  ##
  # Finds the user's home directory.
  #--
  # Some comments from the ruby-talk list regarding finding the home
  # directory:
  #
  #   I have HOME, USERPROFILE and HOMEDRIVE + HOMEPATH. Ruby seems
  #   to be depending on HOME in those code samples. I propose that
  #   it should fallback to USERPROFILE and HOMEDRIVE + HOMEPATH (at
  #   least on Win32).
  #++
  #--
  #
  #++

  def self.find_home
    Dir.home.dup
  rescue StandardError
    if Gem.win_platform?
      File.expand_path File.join(ENV["HOMEDRIVE"] || ENV["SystemDrive"], "/")
    else
      File.expand_path "/"
    end
  end

  private_class_method :find_home

  ##
  # The home directory for the user.

  def self.user_home
    @user_home ||= find_home
  end

  ##
  # Path for gems in the user's home directory

  def self.user_dir
    gem_dir = File.join(Gem.user_home, ".gem")
    gem_dir = File.join(Gem.data_home, "gem") unless File.exist?(gem_dir)
    parts = [gem_dir, ruby_engine]
    ruby_version_dir_name = RbConfig::CONFIG["ruby_version_dir_name"] || RbConfig::CONFIG["ruby_version"]
    parts << ruby_version_dir_name unless ruby_version_dir_name.empty?
    File.join parts
  end

  ##
  # The path to standard location of the user's configuration directory.

  def self.config_home
    @config_home ||= ENV["XDG_CONFIG_HOME"] || File.join(Gem.user_home, ".config")
  end

  ##
  # Finds the user's config file

  def self.find_config_file
    gemrc = File.join Gem.user_home, ".gemrc"
    if File.exist? gemrc
      gemrc
    else
      File.join Gem.config_home, "gem", "gemrc"
    end
  end

  ##
  # The path to standard location of the user's .gemrc file.

  def self.config_file
    @config_file ||= find_config_file
  end

  ##
  # The path to standard location of the user's state file.

  def self.state_file
    @state_file ||= File.join(Gem.state_home, "gem", "last_update_check")
  end

  ##
  # The path to standard location of the user's cache directory.

  def self.cache_home
    @cache_home ||= ENV["XDG_CACHE_HOME"] || File.join(Gem.user_home, ".cache")
  end

  ##
  # The path to standard location of the user's data directory.

  def self.data_home
    @data_home ||= ENV["XDG_DATA_HOME"] || File.join(Gem.user_home, ".local", "share")
  end

  ##
  # The path to standard location of the user's state directory.

  def self.state_home
    @state_home ||= ENV["XDG_STATE_HOME"] || File.join(Gem.user_home, ".local", "state")
  end

  ##
  # How String Gem paths should be split.  Overridable for esoteric platforms.

  def self.path_separator
    File::PATH_SEPARATOR
  end

  ##
  # Default gem load path

  def self.default_path
    path = []
    path << user_dir if user_home && File.exist?(user_home)
    path << default_dir
    path << vendor_dir if vendor_dir && File.directory?(vendor_dir)
    path
  end

  ##
  # Deduce Ruby's --program-prefix and --program-suffix from its install name

  def self.default_exec_format
    exec_format = begin
                    RbConfig::CONFIG["ruby_install_name"].sub("ruby", "%s")
                  rescue StandardError
                    "%s"
                  end

    unless exec_format.include?("%s")
      raise Gem::Exception,
        "[BUG] invalid exec_format #{exec_format.inspect}, no %s"
    end

    exec_format
  end

  ##
  # The default directory for binaries

  def self.default_bindir
    RbConfig::CONFIG["bindir"]
  end

  def self.ruby_engine
    RUBY_ENGINE
  end

  ##
  # The default signing key path

  def self.default_key_path
    default_key_path = File.join Gem.user_home, ".gem", "gem-private_key.pem"

    unless File.exist?(default_key_path)
      default_key_path = File.join Gem.data_home, "gem", "gem-private_key.pem"
    end

    default_key_path
  end

  ##
  # The default signing certificate chain path

  def self.default_cert_path
    default_cert_path = File.join Gem.user_home, ".gem", "gem-public_cert.pem"

    unless File.exist?(default_cert_path)
      default_cert_path = File.join Gem.data_home, "gem", "gem-public_cert.pem"
    end

    default_cert_path
  end

  ##
  # Enables automatic installation into user directory

  def self.default_user_install # :nodoc:
    if !ENV.key?("GEM_HOME") && File.exist?(Gem.dir) && !File.writable?(Gem.dir)
      Gem.ui.say "Defaulting to user installation because default installation directory (#{Gem.dir}) is not writable."
      return true
    end

    false
  end

  ##
  # Install extensions into lib as well as into the extension directory.

  def self.install_extension_in_lib # :nodoc:
    Gem.configuration.install_extension_in_lib
  end

  ##
  # Directory where vendor gems are installed.

  def self.vendor_dir # :nodoc:
    if vendor_dir = ENV["GEM_VENDOR"]
      return vendor_dir.dup
    end

    return nil unless RbConfig::CONFIG.key? "vendordir"

    File.join RbConfig::CONFIG["vendordir"], "gems",
              RbConfig::CONFIG["ruby_version_dir_name"] || RbConfig::CONFIG["ruby_version"]
  end

  ##
  # Default options for gem commands for Ruby packagers.
  #
  # The options here should be structured as an array of string "gem"
  # command names as keys and a string of the default options as values.
  #
  # Example:
  #
  # def self.operating_system_defaults
  #   {
  #       'install' => '--no-rdoc --no-ri --env-shebang',
  #       'update' => '--no-rdoc --no-ri --env-shebang'
  #   }
  # end

  def self.operating_system_defaults
    {}
  end

  ##
  # Default options for gem commands for Ruby implementers.
  #
  # The options here should be structured as an array of string "gem"
  # command names as keys and a string of the default options as values.
  #
  # Example:
  #
  # def self.platform_defaults
  #   {
  #       'install' => '--no-rdoc --no-ri --env-shebang',
  #       'update' => '--no-rdoc --no-ri --env-shebang'
  #   }
  # end

  def self.platform_defaults
    {}
  end
end
                                                                                                                          rubygems/rubygems/request_set/lockfile.rb                                                           0000644                 00000012426 15040313421 0014714 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Parses a gem.deps.rb.lock file and constructs a LockSet containing the
# dependencies found inside.  If the lock file is missing no LockSet is
# constructed.

class Gem::RequestSet::Lockfile
  ##
  # Raised when a lockfile cannot be parsed

  class ParseError < Gem::Exception
    ##
    # The column where the error was encountered

    attr_reader :column

    ##
    # The line where the error was encountered

    attr_reader :line

    ##
    # The location of the lock file

    attr_reader :path

    ##
    # Raises a ParseError with the given +message+ which was encountered at a
    # +line+ and +column+ while parsing.

    def initialize(message, column, line, path)
      @line   = line
      @column = column
      @path   = path
      super "#{message} (at line #{line} column #{column})"
    end
  end

  ##
  # Creates a new Lockfile for the given +request_set+ and +gem_deps_file+
  # location.

  def self.build(request_set, gem_deps_file, dependencies = nil)
    request_set.resolve
    dependencies ||= requests_to_deps request_set.sorted_requests
    new request_set, gem_deps_file, dependencies
  end

  def self.requests_to_deps(requests) # :nodoc:
    deps = {}

    requests.each do |request|
      spec        = request.spec
      name        = request.name
      requirement = request.request.dependency.requirement

      deps[name] = if [Gem::Resolver::VendorSpecification,
                       Gem::Resolver::GitSpecification].include? spec.class
        Gem::Requirement.source_set
      else
        requirement
      end
    end

    deps
  end

  ##
  # The platforms for this Lockfile

  attr_reader :platforms

  def initialize(request_set, gem_deps_file, dependencies)
    @set           = request_set
    @dependencies  = dependencies
    @gem_deps_file = File.expand_path(gem_deps_file)
    @gem_deps_dir  = File.dirname(@gem_deps_file)
    @platforms = []
  end

  def add_DEPENDENCIES(out) # :nodoc:
    out << "DEPENDENCIES"

    out.concat @dependencies.sort.map {|name, requirement|
      "  #{name}#{requirement.for_lockfile}"
    }

    out << nil
  end

  def add_GEM(out, spec_groups) # :nodoc:
    return if spec_groups.empty?

    source_groups = spec_groups.values.flatten.group_by do |request|
      request.spec.source.uri
    end

    source_groups.sort_by {|group,| group.to_s }.map do |group, requests|
      out << "GEM"
      out << "  remote: #{group}"
      out << "  specs:"

      requests.sort_by(&:name).each do |request|
        next if request.spec.name == "bundler"
        platform = "-#{request.spec.platform}" unless
          request.spec.platform == Gem::Platform::RUBY

        out << "    #{request.name} (#{request.version}#{platform})"

        request.full_spec.dependencies.sort.each do |dependency|
          next if dependency.type == :development

          requirement = dependency.requirement
          out << "      #{dependency.name}#{requirement.for_lockfile}"
        end
      end
      out << nil
    end
  end

  def add_GIT(out, git_requests)
    return if git_requests.empty?

    by_repository_revision = git_requests.group_by do |request|
      source = request.spec.source
      [source.repository, source.rev_parse]
    end

    by_repository_revision.each do |(repository, revision), requests|
      out << "GIT"
      out << "  remote: #{repository}"
      out << "  revision: #{revision}"
      out << "  specs:"

      requests.sort_by(&:name).each do |request|
        out << "    #{request.name} (#{request.version})"

        dependencies = request.spec.dependencies.sort_by(&:name)
 