
    mingw_18: x86_mingw,
    mingw_19: x86_mingw,
    mingw_20: x86_mingw,
    mingw_21: x86_mingw,
    mri: Gem::Platform::RUBY,
    mri_18: Gem::Platform::RUBY,
    mri_19: Gem::Platform::RUBY,
    mri_20: Gem::Platform::RUBY,
    mri_21: Gem::Platform::RUBY,
    mswin: mswin,
    mswin_18: mswin,
    mswin_19: mswin,
    mswin_20: mswin,
    mswin_21: mswin,
    mswin64: mswin64,
    mswin64_19: mswin64,
    mswin64_20: mswin64,
    mswin64_21: mswin64,
    rbx: Gem::Platform::RUBY,
    ruby: Gem::Platform::RUBY,
    ruby_18: Gem::Platform::RUBY,
    ruby_19: Gem::Platform::RUBY,
    ruby_20: Gem::Platform::RUBY,
    ruby_21: Gem::Platform::RUBY,
    truffleruby: Gem::Platform::RUBY,
    x64_mingw: x64_mingw,
    x64_mingw_20: x64_mingw,
    x64_mingw_21: x64_mingw,
  }.freeze

  gt_eq_0        = Gem::Requirement.new ">= 0"
  tilde_gt_1_8_0 = Gem::Requirement.new "~> 1.8.0"
  tilde_gt_1_9_0 = Gem::Requirement.new "~> 1.9.0"
  tilde_gt_2_0_0 = Gem::Requirement.new "~> 2.0.0"
  tilde_gt_2_1_0 = Gem::Requirement.new "~> 2.1.0"

  VERSION_MAP = { # :nodoc:
    jruby: gt_eq_0,
    jruby_18: tilde_gt_1_8_0,
    jruby_19: tilde_gt_1_9_0,
    maglev: gt_eq_0,
    mingw: gt_eq_0,
    mingw_18: tilde_gt_1_8_0,
    mingw_19: tilde_gt_1_9_0,
    mingw_20: tilde_gt_2_0_0,
    mingw_21: tilde_gt_2_1_0,
    mri: gt_eq_0,
    mri_18: tilde_gt_1_8_0,
    mri_19: tilde_gt_1_9_0,
    mri_20: tilde_gt_2_0_0,
    mri_21: tilde_gt_2_1_0,
    mswin: gt_eq_0,
    mswin_18: tilde_gt_1_8_0,
    mswin_19: tilde_gt_1_9_0,
    mswin_20: tilde_gt_2_0_0,
    mswin_21: tilde_gt_2_1_0,
    mswin64: gt_eq_0,
    mswin64_19: tilde_gt_1_9_0,
    mswin64_20: tilde_gt_2_0_0,
    mswin64_21: tilde_gt_2_1_0,
    rbx: gt_eq_0,
    ruby: gt_eq_0,
    ruby_18: tilde_gt_1_8_0,
    ruby_19: tilde_gt_1_9_0,
    ruby_20: tilde_gt_2_0_0,
    ruby_21: tilde_gt_2_1_0,
    truffleruby: gt_eq_0,
    x64_mingw: gt_eq_0,
    x64_mingw_20: tilde_gt_2_0_0,
    x64_mingw_21: tilde_gt_2_1_0,
  }.freeze

  WINDOWS = { # :nodoc:
    mingw: :only,
    mingw_18: :only,
    mingw_19: :only,
    mingw_20: :only,
    mingw_21: :only,
    mri: :never,
    mri_18: :never,
    mri_19: :never,
    mri_20: :never,
    mri_21: :never,
    mswin: :only,
    mswin_18: :only,
    mswin_19: :only,
    mswin_20: :only,
    mswin_21: :only,
    mswin64: :only,
    mswin64_19: :only,
    mswin64_20: :only,
    mswin64_21: :only,
    rbx: :never,
    ruby: :never,
    ruby_18: :never,
    ruby_19: :never,
    ruby_20: :never,
    ruby_21: :never,
    x64_mingw: :only,
    x64_mingw_20: :only,
    x64_mingw_21: :only,
  }.freeze

  ##
  # The gems required by #gem statements in the gem.deps.rb file

  attr_reader :dependencies

  ##
  # A set of gems that are loaded via the +:git+ option to #gem

  attr_reader :git_set # :nodoc:

  ##
  # A Hash containing gem names and files to require from those gems.

  attr_reader :requires

  ##
  # A set of gems that are loaded via the +:path+ option to #gem

  attr_reader :vendor_set # :nodoc:

  ##
  # The groups of gems to exclude from installation

  attr_accessor :without_groups # :nodoc:

  ##
  # Creates a new GemDependencyAPI that will add dependencies to the
  # Gem::RequestSet +set+ based on the dependency API description in +path+.

  def initialize(set, path)
    @set = set
    @path = path

    @current_groups     = nil
    @current_platforms  = nil
    @current_repository = nil
    @dependencies       = {}
    @default_sources    = true
    @git_set            = @set.git_set
    @git_sources        = {}
    @installing         = false
    @requires           = Hash.new {|h, name| h[name] = [] }
    @vendor_set         = @set.vendor_set
    @source_set         = @set.source_set
    @gem_sources        = {}
    @without_groups     = []

    git_source :github do |repo_name|
      repo_name = "#{repo_name}/#{repo_name}" unless repo_name.include? "/"

      "https://github.com/#{repo_name}.git"
    end

    git_source :bitbucket do |repo_name|
      repo_name = "#{repo_name}/#{repo_name}" unless repo_name.include? "/"

      user, = repo_name.split "/", 2

      "https://#{user}@bitbucket.org/#{repo_name}.git"
    end
  end

  ##
  # Adds +dependencies+ to the request set if any of the +groups+ are allowed.
  # This is used for gemspec dependencies.

  def add_dependencies(groups, dependencies) # :nodoc:
    return unless (groups & @without_groups).empty?

    dependencies.each do |dep|
      @set.gem dep.name, *dep.requirement.as_list
    end
  end

  private :add_dependencies

  ##
  # Finds a gemspec with the given +name+ that lives at +path+.

  def find_gemspec(name, path) # :nodoc:
    glob = File.join path, "#{name}.gemspec"

    spec_files = Dir[glob]

    case spec_files.length
    when 1 then
      spec_file = spec_files.first

      spec = Gem::Specification.load spec_file

      return spec if spec

      raise ArgumentError, "invalid gemspec #{spec_file}"
    when 0 then
      raise ArgumentError, "no gemspecs found at #{Dir.pwd}"
    else
      raise ArgumentError,
        "found multiple gemspecs at #{Dir.pwd}, " \
        "use the name: option to specify the one you want"
    end
  end

  ##
  # Changes the behavior of gem dependency file loading to installing mode.
  # In installing mode certain restrictions are ignored such as ruby version
  # mismatch checks.

  def installing=(installing) # :nodoc:
    @installing = installing
  end

  ##
  # Loads the gem dependency file and returns self.

  def load
    instance_eval File.read(@path), @path, 1

    self
  end

  ##
  # :category: Gem Dependencies DSL
  #
  # :call-seq:
  #   gem(name)
  #   gem(name, *requirements)
  #   gem(name, *requirements, options)
  #
  # Specifies a gem dependency with the given +name+ and +requirements+.  You
  # may also supply +options+ following the +requirements+
  #
  # +options+ include:
  #
  # require: ::
  #   RubyGems does not provide any autorequire features so requires in a gem
  #   dependencies file are recorded but ignored.
  #
  #   In bundler the require: option overrides the file to require during
  #   Bundler.require.  By default the name of the dependency is required in
  #   Bundler.  A single file or an Array of files may be given.
  #
  #   To disable requiring any file give +false+:
  #
  #     gem 'rake', require: false
  #
  # group: ::
  #   Place the dependencies in the given dependency group.  A single group or
  #   an Array of groups may be given.
  #
  #   See also #group
  #
  # platform: ::
  #   Only install the dependency on the given platform.  A single platform or
  #   an Array of platforms may be given.
  #
  #   See #platform for a list of platforms available.
  #
  # path: ::
  #   Install this dependency from an unpacked gem in the given directory.
  #
  #     gem 'modified_gem', path: 'vendor/modified_gem'
  #
  # git: ::
  #   Install this dependency from a git repository:
  #
  #     gem 'private_gem', git: 'git@my.company.example:private_gem.git'
  #
  # gist: ::
  #   Install this dependency from the gist ID:
  #
  #     gem 'bang', gist: '1232884'
  #
  # github: ::
  #   Install this dependency from a github git repository:
  #
  #     gem 'private_gem', github: 'my_company/private_gem'
  #
  # submodules: ::
  #   Set to +true+ to include submodules when fetching the git repository for
  #   git:, gist: and github: dependencies.
  #
  # ref: ::
  #   Us