rms.each do |platform|
      out << "  #{platform}"
    end

    out << nil
  end

  def spec_groups
    requests.group_by {|request| request.spec.class }
  end

  ##
  # The contents of the lock file.

  def to_s
    out = []

    groups = spec_groups

    add_PATH out, groups.delete(Gem::Resolver::VendorSpecification) { [] }

    add_GIT out, groups.delete(Gem::Resolver::GitSpecification) { [] }

    add_GEM out, groups

    add_PLATFORMS out

    add_DEPENDENCIES out

    out.join "\n"
  end

  ##
  # Writes the lock file alongside the gem dependencies file

  def write
    content = to_s

    File.open "#{@gem_deps_file}.lock", "w" do |io|
      io.write content
    end
  end

  private

  def requests
    @set.sorted_requests
  end
end

require_relative "lockfile/tokenizer"
                                                                                                                                                                                                                                          rubygems/rubygems/request_set/gem_dependency_api.rb                                                 0000644                 00000053313 15040313421 0016723 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# A semi-compatible DSL for the Bundler Gemfile and Isolate gem dependencies
# files.
#
# To work with both the Bundler Gemfile and Isolate formats this
# implementation takes some liberties to allow compatibility with each, most
# notably in #source.
#
# A basic gem dependencies file will look like the following:
#
#   source 'https://rubygems.org'
#
#   gem 'rails', '3.2.14a
#   gem 'devise', '~> 2.1', '>= 2.1.3'
#   gem 'cancan'
#   gem 'airbrake'
#   gem 'pg'
#
# RubyGems recommends saving this as gem.deps.rb over Gemfile or Isolate.
#
# To install the gems in this Gemfile use `gem install -g` to install it and
# create a lockfile.  The lockfile will ensure that when you make changes to
# your gem dependencies file a minimum amount of change is made to the
# dependencies of your gems.
#
# RubyGems can activate all the gems in your dependencies file at startup
# using the RUBYGEMS_GEMDEPS environment variable or through Gem.use_gemdeps.
# See Gem.use_gemdeps for details and warnings.
#
# See `gem help install` and `gem help gem_dependencies` for further details.

class Gem::RequestSet::GemDependencyAPI
  ENGINE_MAP = { # :nodoc:
    jruby: %w[jruby],
    jruby_18: %w[jruby],
    jruby_19: %w[jruby],
    maglev: %w[maglev],
    mri: %w[ruby],
    mri_18