gory: Gem Dependencies DSL
  #
  # Block form for restricting gems to a particular set of platforms.  See
  # #platform.

  alias_method :platforms, :platform

  ##
  # :category: Gem Dependencies DSL
  #
  # Restricts this gem dependencies file to the given ruby +version+.
  #
  # You may also provide +engine:+ and +engine_version:+ options to restrict
  # this gem dependencies file to a particular ruby engine and its engine
  # version.  This matching is performed by using the RUBY_ENGINE and
  # RUBY_ENGINE_VERSION constants.

  def ruby(version, options = {})
    engine         = options[:engine]
    engine_version = options[:engine_version]

    raise ArgumentError,
          "You must specify engine_version along with the Ruby engine" if
            engine && !engine_version

    return true if @installing

    unless version == RUBY_VERSION
      message = "Your Ruby version is #{RUBY_VERSION}, " \
                "but your #{gem_deps_file} requires #{version}"

      raise Gem::RubyVersionMismatch, message
    end

    if engine && engine != Gem.ruby_engine
      message = "Your Ruby engine is #{Gem.ruby_engine}, " \
                "but your #{gem_deps_file} requires #{engine}"

      raise Gem::RubyVersionMismatch, message
    end

    if engine_version
      if engine_version != RUBY_ENGINE_VERSION
        message =
          "Your Ruby engine version is #{Gem.ruby_engine} #{RUBY_ENGINE_VERSION}, " \
          "but your #{gem_deps_file} requires #{engine} #{engine_version}"

        raise Gem::RubyVersionMismatch, message
      end
    end

    true
  end

  ##
  # :category: Gem Dependencies DSL
  #
  # Sets +url+ as a source for gems for this dependency API.  RubyGems uses
  # the default configured sources if no source was given.  If a source is set
  # only that source is used.
  #
  # This method differs in behavior from Bundler:
  #
  # * The +:gemcutter+, # +:rubygems+ and +:rubyforge+ sources are not
  #   supported as they are deprecated in bundler.
  # * The +prepend:+ option is not supported.  If you wish to order sources
  #   then list them in your preferred order.

  def source(url)
    Gem.sources.clear if @default_sources

    @default_sources = false

    Gem.sources << url
  end
end
                                                                                                                                                                                                                                                                                                                     rubygems/rubygems/request_set/lockfile/tokenizer.rb                                                 0000644                 00000005373 15040313421 0016731 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# ) frozen_string_literal: true
require_relative "parser"

class Gem::RequestSet::Lockfile::Tokenizer
  Token = Struct.new :type, :value, :column, :line
  EOF   = Token.new :EOF

  def self.from_file(file)
    new File.read(file), file
  end

  def initialize(input, filename = nil, line = 0, pos = 0)
    @line     = line
    @line_pos = pos
    @tokens   = []
    @filename = filename
    tokenize input
  end

  def make_parser(set, platforms)
    Gem::RequestSet::Lockfile::Parser.new self, set, platforms, @filename
  end

  def to_a
    @tokens.map {|token| [token.type, token.value, token.column, token.line] }
  end

  def skip(type)
    @tokens.shift while !@tokens.empty? && peek.type == type
  end

  ##
  # Calculates the column (by byte) and the line of the current token based on
  # +byte_offset+.

  def token_pos(byte_offset) # :nodoc:
    [byte_offset - @line_pos, @line]
  end

  def empty?
    @tokens.empty?
  end

  def unshift(token)
    @tokens.unshift token
  end

  def next_token
    @tokens.shift
  end
  alias_method :shift, :next_token

  def peek
    @tokens.first || EOF
  end

  private

  def tokenize(input)
    require "strscan"
    s = StringScanner.new input

    until s.eos? do
      pos = s.pos

      pos = s.pos if leading_whitespace = s.scan(/ +/)

      if s.scan(/[<|=>]{7}/)
        message = "your #{@filename} contains merge conflict markers"
        column, line = token_pos pos

        raise Gem::RequestSet::Lockfile::ParseError.new message, column, line, @filename
      end

      @tokens <<
        if s.scan(/\r?\n/)

          token = Token.new(:newline, nil, *token_pos(pos))
          @line_pos = s.pos
          @line += 1
          token
        elsif s.scan(/[A-Z]+/)

          if leading_whitespace
            text = s.matched
            text += s.scan(/[^\s)]*/).to_s # in case of no match
            Token.new(:text, text, *token_pos(pos))
          else
            Token.new(:section, s.matched, *token_pos(pos))
          end
        elsif s.scan(/([a-z]+):\s/)

          s.pos -= 1 # rewind for possible newline
          Token.new(:entry, s[1], *token_pos(pos))
        elsif s.scan(/\(/)

          Token.new(:l_paren, nil, *token_pos(pos))
        elsif s.scan(/\)/)

          Token.new(:r_paren, nil, *token_pos(pos))
        elsif s.scan(/<=|>=|=|~>|<|>|!=/)

          Token.new(:requirement, s.matched, *token_pos(pos))
        elsif s.scan(/,/)

          Token.new(:comma, nil, *token_pos(pos))
        elsif s.scan(/!/)

          Token.new(:bang, nil, *token_pos(pos))
        elsif s.scan(/[^\s),!]*/)

          Token.new(:text, s.matched, *token_pos(pos))
        else
          raise "BUG: can't create token for: #{s.string[s.pos..-1].inspect}"
        end
    end

    @tokens
  end
end
                                                                                                                                                                                                                                                                     rubygems/rubygems/request_set/lockfile/parser.rb                                                    0000644                 00000016370 15040313421 0016212 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

class Gem::RequestSet::Lockfile::Parser
  ###
  # Parses lockfiles

  def initialize(tokenizer, set, platforms, filename = nil)
    @tokens    = tokenizer
    @filename  = filename
    @set       = set
    @platforms = platforms
  end

  def parse
    until @tokens.empty? do
      token = get

      case token.type
      when :section then
        @tokens.skip :newline

        case token.value
        when "DEPENDENCIES" then
          parse_DEPENDENCIES
        when "GIT" then
          parse_GIT
        when "GEM" then
          parse_GEM
        when "PATH" then
          parse_PATH
        when "PLATFORMS" then
          parse_PLATFORMS
        else
          token = get until @tokens.empty? || peek.first == :section
        end
      else
        raise "BUG: unhandled token #{token.type} (#{token.value.inspect}) at line #{token.line} column #{token.column}"
      end
    end
  end

  ##
  # Gets the next token for a Lockfile

  def get(expected_types = nil, expected_value = nil) # :nodoc:
    token = @tokens.shift

    if expected_types && !Array(expected_types).include?(token.type)
      unget token

      message = "unexpected token [#{token.type.inspect}, #{token.value.inspect}], " \
                "expected #{expected_types.inspect}"

      raise Gem::RequestSet::Lockfile::ParseError.new message, token.column, token.line, @filename
    end

    if expected_value && expected_value != token.value
      unget token

      message = "unexpected token [#{token.type.inspect}, #{token.value.inspect}], " \
                "expected [#{expected_types.inspect}, " \
                "#{expected_value.inspect}]"

      raise Gem::RequestSet::Lockfile::ParseError.new message, token.column, token.line, @filename
    end

    token
  end

  def parse_DEPENDENCIES # :nodoc:
    while !@tokens.empty? && peek.type == :text do
      token = get :text

      requirements = []

      case peek[0]
      when :bang then
        get :bang

        requirements << pinned_requirement(token.value)
      when :l_paren then
        get :l_paren

        loop do
          op      = get(:requirement).value
          version = get(:text).value

          requirements << "#{op} #{version}"

          break unless peek.type == :comma

          get :comma
        end

        get :r_paren

        if peek[0] == :bang
          requirements.clear
          requirements << pinned_requirement(token.value)

          get :bang
        end
      end

      @set.gem token.value, *requirements

      skip :newline
    end
  end

  def parse_GEM # :nodoc:
    sources = []

    while peek.first(2) == [:entry, "remote"] do
      get :entry, "remote"
      data = get(:text).value
      skip :newline

      sources << Gem::Source.new(data)
    end

    sources << Gem::Source.new(Gem::DEFAULT_HOST) if sources.empty?

    get :entry, "specs"

    skip :newline

    set = Gem::Resolver::LockSet.new sources
    last_specs = nil

    while !@tokens.empty? && peek.type == :text do
      token = get :text
      name = token.value
      column = token.column

      case peek[0]
      when :newline then
        last_specs.each do |spec|
          spec.add_dependency Gem