che"))
  end

  ##
  # The path to standard location of the user's data directory.

  def self.data_home
    @data_home ||= (ENV["XDG_DATA_HOME"] || File.join(Gem.user_home, ".local", "share"))
  end

  ##
  # The path to standard location of the user's state directory.

  def self.state_home
    @state_home ||= (ENV["XDG_STATE_HOME"] || File.join(Gem.user_home, ".local", "state"))
  end

  ##
  # How String Gem paths should be split.  Overridable for esoteric platforms.

  def self.path_separator
    File::PATH_SEPARATOR
  end

  ##
  # Default gem load path

  def self.default_path
    path = []
    path << user_dir if user_home && File.exist?(user_home)
    path << default_dir
    path << vendor_dir if vendor_dir && File.directory?(vendor_dir)
    path
  end

  ##
  # Deduce Ruby's --program-prefix and --program-suffix from its install name

  def self.default_exec_format
    exec_format = RbConfig::CONFIG["ruby_install_name"].sub("ruby", "%s") rescue "%s"

    unless exec_format.include?("%s")
      raise Gem::Exception,
        "[BUG] invalid exec_format #{exec_format.inspect}, no %s"
    end

    exec_format
  end

  ##
  # The default directory for binaries

  def self.default_bindir
    RbConfig::CONFIG["bindir"]
  end

  def self.ruby_engine
    RUBY_ENGINE
                                                rubygems/rubygems/request_set/lockfile.rb                                                           0000644                 00000012714 15040313421 0014714 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ome, "gem", "gem-public_cert.pem"
    end

    default_cert_path
  end

  ##
  # Install extensions into lib as well as into the extension directory.

  def self.install_extension_in_lib # :nodoc:
    true
  end

  ##
  # Directory where vendor gems are installed.

  def self.vendor_dir # :nodoc:
    if vendor_dir = ENV["GEM_VENDOR"]
      return vendor_dir.dup
                                                                                                                                                                                                                                                                                                                                                             rubygems/rubygems/resolver/molinillo/lib/molinillo/state.rb                                         0000644                 00000003456 15040313417 0020314 0                                                                                                    ustar 00                                                                                                                                                