rubygems/rubygems/spec_fetcher.rb                                                                   0000644                 00000017274 15040313417 0013226 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "remote_fetcher"
require_relative "user_interaction"
require_relative "errors"
require_relative "text"
require_relative "name_tuple"

##
# SpecFetcher handles metadata updates from remote gem repositories.

class Gem::SpecFetcher
  include Gem::UserInteraction
  include Gem::Text

  ##
  # Cache of latest specs

  attr_reader :latest_specs # :nodoc:

  ##
  # Sources for this SpecFetcher

  attr_reader :sources # :nodoc:

  ##
  # Cache of all released specs

  attr_reader :specs # :nodoc:

  ##
  # Cache of prerelease specs

  attr_reader :prerelease_specs # :nodoc:

  @fetcher = nil

  ##
  # Default fetcher instance.  Use this instead of ::new to reduce object
  # allocation.

  def self.fetcher
    @fetcher ||= new
  end

  def self.fetcher=(fetcher) # :nodoc:
    @fetcher = fetcher
  end

  ##
  # Creates a new SpecFetcher.  Ordinarily you want to use the default fetcher
  # from Gem::SpecFetcher::fetcher which uses the Gem.sources.
  #
  # If you need to retrieve specifications from a different +source+, you can
  # send it as an argument.

  def initialize(sources = nil)
    @sources = sources || Gem.sources

    @update_cache =
      begin
        File.stat(Gem.user_home).uid == Process.uid
      rescue Errno::EACCES, Errno::ENOENT
        false
      end

    @specs = {}
    @latest_specs = {}
    @prerelease_specs = {}

    @caches = {
      latest: @latest_specs,
      prerelease: @prerelease_specs,
      released: @specs,
    }

    @fetcher = Gem::RemoteFetcher.fetcher
  end

  ##
  #
  # Find and fetch gem name tuples that match +dependency+.
  #
  # If +matching_platform+ is false, gems for all platforms are returned.

  def search_for_dependency(dependency, matching_platform=true)
    found = {}

    rejected_specs = {}

    list, errors = available_specs(dependency.identity)

    list.each do |source, specs|
      if dependency.name.is_a?(String) && specs.respond_to?(:bsearch)
        start_index = (0...specs.length).bsearch {|i| specs[i].name >= dependency.name }
        end_index   = (0...specs.length).bsearch {|i| specs[i].name > dependency.name }
        specs = specs[start_index...end_index] if start_index && end_index
      end

      found[source] = specs.select do |tup|
        if