rder, you don't get into as many dependency
  # issues.
  #
  # If there are circular dependencies (yuck!), then gems will be returned in
  # order until only the circular dependents and anything they reference are
  # left.  Then arbitrary gemspecs will be returned until the circular
  # dependency is broken, after which gems will be returned in dependency
  # order again.

  def dependency_order
    sorted = strongly_connected_components.flatten

    result = []
    seen = {}

    sorted.each do |spec|
      if index = seen[spec.name]
        if result[index].version < spec.version
          result[index] = spec
        end
      else
        seen[spec.name] = result.length
        result << spec
      end
    end

    result.reverse
  end

  ##
  # Iterator over dependency_order

  def each(&block)
    dependency_order.each(&block)
  end

  def find_name(full_name)
    @specs.find {|spec| spec.full_name == full_name }
  end

  def inspect # :nodoc:
    format("%s %p>", super[0..-2], map(&:full_name))
  end

  ##
  # Are all the dependencies in the list satisfied?

  def ok?
    why_not_ok?(:quick).empty?
  end

  def why_not_ok?(quick = false)
    unsatisfied = Hash.new {|h,k| h[k] = [] }
    each do |spec|
      spec.runtime_dependencies.each do |dep|
        inst = Gem::Specification.any? do |installed_spec|
          dep.name == installed_spec.name &&
            dep.requirement.satisfied_by?(installed_spec.version)
        end

        unless inst || @specs.find {|s| s.satisfies_requirement? dep }
          unsatisfied[spec.name] << dep
          return unsatisfied if quick
        end
      end
    end

    unsatisfied
  end

  ##
  # It is ok to remove a gemspec from the dependency list?
  #
  # If removing the gemspec creates breaks a currently ok dependency, then it
  # is NOT ok to remove the gemspec.

  def ok_to_remove?(full_name, check_dev=true)
    gem_to_remove = find_name full_name

    # If the state is inconsistent, at least don't crash
    return true unless gem_to_remove

    siblings = @specs.find_all do |s|
      s.name == gem_to_remove.name &&
        s.full_name != gem_to_remove.full_name
    end

    deps = []

    @specs.each do |spec|
      check = check_dev ? spec.dependencies : spec.runtime_dependencies

      check.each do |dep|
     