  end

  def add_GEM(out, spec_groups) # :nodoc:
    return if spec_groups.empty?

    source_groups = spec_groups.values.flatten.group_by do |request|
      request.spec.source.uri
    end

    source_groups.sort_by {|group,| group.to_s }.map do |group, requests|
      out << "GEM"
      out << "  remote: #{group}"
      out << "  specs:"

      requests.sort_by {|request| request.name }.each do |request|
        next if request.spec.name == "bundler"
        platform = "-#{request.spec.platform}" unless
          Gem::Platform::RUBY == request.spec.platform

        out << "    #{request.name} (#{request.version}#{platform})"

        request.full_spec.dependencies.sort.each do |dependency|
          next if dependency.type == :development

          requirement = dependency.requirement
          out << "      #{dependency.name}#{requirement.for_lockfile}"
        end
      end
      out << nil
    end
  end

  def add_GIT(out, git_requests)
    return if git_requests.empty?

    by_repository_revision = git_requests.group_by do |request|
      source = request.spec.source
      [source.repository, source.rev_parse]
    end

    by_repository_revision.each do |(repository, revision), requests|
      out << "GIT"
      out << "  remote: #{repository}"
      out                                                     rubygems/rubygems/request_set/gem_dependency_api.rb                                                 0000644                 00000054052 15040313421 0016724 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ffset = dest[base.size + 1..-1]

      return "." unless offset

      offset
    else
      dest
    end
  end

  def add_PATH(out, path_requests) # :nodoc:
    return if path_requests.empty?

    out << "PATH"
    path_requests.each do |request|
      directory = File.expand_path(request.spec.source.uri)

      out << "  remote: #{relative_path_from directory, @gem_deps_dir}"
      out << "  specs:"
      out << "    #{request.name} (#{request.version})"
    end

    out << nil
  end

  def add_PLATFORMS(out) # :nodoc:
    out << "PLATFORMS"

    platforms = requests.map {|request| request.spec.platform }.uniq

    platforms = platforms.sort_by {|platform| platform.to_s }

    platforms.each do |platform|
      out << "  #{platform}"
    end

    out << nil
  end

  def spec_groups
    requests.group_by {|request| request.spec.class }
  end

  ##
  # The contents of the lock file.

  def to_s
    out = []

    groups = spec_groups

    add_PATH out, groups.delete(Gem::Resolver::VendorSpecification) { [] }

    add_GIT out, groups.delete(Gem::Resolver::GitSpecification) { [] }

    add_GE