rubygems/rubygems/resolver/dependency_request.rb                                                    0000644                 00000004402 15040313417 0016310 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

##
# Used Internally. Wraps a Dependency object to also track which spec
# contained the Dependency.

class Gem::Resolver::DependencyRequest
  ##
  # The wrapped Gem::Dependency

  attr_reader :dependency

  ##
  # The request for this dependency.

  attr_reader :requester

  ##
  # Creates a new DependencyRequest for +dependency+ from +requester+.
  # +requester may be nil if the request came from a user.

  def initialize(dependency, requester)
    @dependency = dependency
    @requester  = requester
  end

  def ==(other) # :nodoc:
    case other
    when Gem::Dependency
      @dependency == other
    when Gem::Resolver::DependencyRequest
      @dependency == other.dependency
    else
      false
    end
  end

  ##
  # Is this dependency a development dependency?

  def development?
    @dependency.type == :development
  end

  ##
  # Does this dependency request match +spec+?
  #
  # N