emote
    names = reqs.map {|r| r.dependency.name }
    needed = names - @data.keys - @to_fetch

    @to_fetch += needed
  end

  def prefetch_now # :nodoc:
    needed = @to_fetch
    @to_fetch = []

    needed.sort.each do |name|
      versions(name)
    end
  end

  def pretty_print(q) # :nodoc:
    q.group 2, "[APISet", "]" do
      q.breakable
      q.text "URI: #{@dep_uri}"

      q.breakable
      q.text "gem names:"
      q.pp @data.keys
    end
  end

  ##
  # Return data for all versions of the gem +name+.

  def versions(name) # :nodoc:
    if @data.key?(name)
      return @data[name]
    end

    uri = @dep_uri + name

    begin
      str = Gem::RemoteFetcher.fetcher.fetch_path uri
    rescue Gem::RemoteFetcher::FetchError
      @data[name] = []
    else
      lines(str).each do |ver|
        number, platform, dependencies, requirements = parse_gem(ver)

        platform ||= "ruby"
        dependencies = dependencies.map {|dep_name, reqs| [dep_name, reqs.join(", ")] }
        requirements = requirements.map {|req_name, reqs| [req_name.to_sym, reqs] }.to_h

        @data[name] << { name: name, number: number, platform: platform, dependencies: dependencies, requirements: requirements }
      end
    end

    @data[